/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.datagraph.node;

import io.datakernel.datagraph.graph.StreamId;
import io.datakernel.datagraph.graph.TaskContext;
import io.datakernel.datagraph.node.Node;
import io.datakernel.stream.StreamConsumer;
import io.datakernel.stream.processor.StreamReducer;
import io.datakernel.stream.processor.StreamReducers;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;

public final class NodeReduce<K, O, A>
implements Node {
    private Comparator<K> keyComparator;
    private Map<StreamId, Input<K, O, A>> inputs;
    private StreamId output;

    public NodeReduce() {
    }

    public NodeReduce(Comparator<K> keyComparator) {
        this.keyComparator = keyComparator;
        this.inputs = new LinkedHashMap<StreamId, Input<K, O, A>>();
        this.output = new StreamId();
    }

    public <I> void addInput(StreamId streamId, Function<I, K> keyFunction, StreamReducers.Reducer<K, I, O, A> reducer) {
        this.inputs.put(streamId, new Input<K, O, A>(reducer, keyFunction));
    }

    @Override
    public Collection<StreamId> getOutputs() {
        return Collections.singletonList(this.output);
    }

    @Override
    public void createAndBind(TaskContext taskContext) {
        StreamReducer streamReducer = StreamReducer.create(this.keyComparator);
        for (StreamId streamId : this.inputs.keySet()) {
            Input<K, O, A> koaInput = this.inputs.get(streamId);
            StreamConsumer input = streamReducer.newInput(((Input)koaInput).keyFunction::apply, ((Input)koaInput).reducer);
            taskContext.bindChannel(streamId, input);
        }
        taskContext.export(this.output, streamReducer.getOutput());
    }

    public Comparator<K> getKeyComparator() {
        return this.keyComparator;
    }

    public void setKeyComparator(Comparator<K> keyComparator) {
        this.keyComparator = keyComparator;
    }

    public Map<StreamId, Input<K, O, A>> getInputs() {
        return this.inputs;
    }

    public void setInputs(Map<StreamId, Input<K, O, A>> inputs) {
        this.inputs = inputs;
    }

    public StreamId getOutput() {
        return this.output;
    }

    public void setOutput(StreamId output) {
        this.output = output;
    }

    public static class Input<K, O, A> {
        private StreamReducers.Reducer<K, ?, O, A> reducer;
        private Function<?, K> keyFunction;

        public Input() {
        }

        public Input(StreamReducers.Reducer<K, ?, O, A> reducer, Function<?, K> keyFunction) {
            this.reducer = reducer;
            this.keyFunction = keyFunction;
        }

        public StreamReducers.Reducer<K, ?, O, A> getReducer() {
            return this.reducer;
        }

        public void setReducer(StreamReducers.Reducer<K, ?, O, A> reducer) {
            this.reducer = reducer;
        }

        public Function<?, K> getKeyFunction() {
            return this.keyFunction;
        }

        public void setKeyFunction(Function<?, K> keyFunction) {
            this.keyFunction = keyFunction;
        }
    }
}

