/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.datagraph.node;

import io.datakernel.datagraph.graph.StreamId;
import io.datakernel.datagraph.graph.TaskContext;
import io.datakernel.datagraph.node.Node;
import io.datakernel.stream.processor.StreamReducerSimple;
import io.datakernel.stream.processor.StreamReducers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;

public final class NodeReduceSimple<K, I, O, A>
implements Node {
    private Function<I, K> keyFunction;
    private Comparator<K> keyComparator;
    private StreamReducers.Reducer<K, I, O, A> reducer;
    private List<StreamId> inputs;
    private StreamId output;

    public NodeReduceSimple() {
    }

    public NodeReduceSimple(Function<I, K> keyFunction, Comparator<K> keyComparator, StreamReducers.Reducer<K, I, O, A> reducer) {
        this.keyFunction = keyFunction;
        this.keyComparator = keyComparator;
        this.reducer = reducer;
        this.inputs = new ArrayList<StreamId>();
        this.output = new StreamId();
    }

    public void addInput(StreamId input) {
        this.inputs.add(input);
    }

    @Override
    public Collection<StreamId> getOutputs() {
        return Collections.singletonList(this.output);
    }

    @Override
    public void createAndBind(TaskContext taskContext) {
        StreamReducerSimple streamReducerSimple = StreamReducerSimple.create(this.keyFunction, this.keyComparator, this.reducer);
        for (StreamId input : this.inputs) {
            taskContext.bindChannel(input, streamReducerSimple.newInput());
        }
        taskContext.export(this.output, streamReducerSimple.getOutput());
    }

    public Function<I, K> getKeyFunction() {
        return this.keyFunction;
    }

    public void setKeyFunction(Function<I, K> keyFunction) {
        this.keyFunction = keyFunction;
    }

    public Comparator<K> getKeyComparator() {
        return this.keyComparator;
    }

    public void setKeyComparator(Comparator<K> keyComparator) {
        this.keyComparator = keyComparator;
    }

    public StreamReducers.Reducer<K, I, O, A> getReducer() {
        return this.reducer;
    }

    public void setReducer(StreamReducers.Reducer<K, I, O, A> reducer) {
        this.reducer = reducer;
    }

    public List<StreamId> getInputs() {
        return this.inputs;
    }

    public void setInputs(List<StreamId> inputs) {
        this.inputs = inputs;
    }

    public StreamId getOutput() {
        return this.output;
    }

    public void setOutput(StreamId output) {
        this.output = output;
    }
}

