/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.datagraph.node;

import io.datakernel.datagraph.graph.StreamId;
import io.datakernel.datagraph.graph.TaskContext;
import io.datakernel.datagraph.node.Node;
import io.datakernel.stream.processor.StreamSorter;
import io.datakernel.stream.processor.StreamSorterStorage;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.function.Function;

public final class NodeSort<K, T>
implements Node {
    private Function<T, K> keyFunction;
    private Comparator<K> keyComparator;
    private boolean deduplicate;
    private int itemsInMemorySize;
    private StreamId input;
    private StreamId output;

    public NodeSort() {
    }

    public NodeSort(Function<T, K> keyFunction, Comparator<K> keyComparator, boolean deduplicate, int itemsInMemorySize, StreamId input) {
        this.keyFunction = keyFunction;
        this.keyComparator = keyComparator;
        this.deduplicate = deduplicate;
        this.itemsInMemorySize = itemsInMemorySize;
        this.input = input;
        this.output = new StreamId();
    }

    @Override
    public Collection<StreamId> getOutputs() {
        return Collections.singletonList(this.output);
    }

    @Override
    public void createAndBind(TaskContext taskContext) {
        StreamSorter streamSorter = StreamSorter.create((StreamSorterStorage)taskContext.environment().getInstance(StreamSorterStorage.class), this.keyFunction, this.keyComparator, (boolean)this.deduplicate, (int)this.itemsInMemorySize);
        taskContext.bindChannel(this.input, streamSorter.getInput());
        taskContext.export(this.output, streamSorter.getOutput());
    }

    public Function<T, K> getKeyFunction() {
        return this.keyFunction;
    }

    public void setKeyFunction(Function<T, K> keyFunction) {
        this.keyFunction = keyFunction;
    }

    public Comparator<K> getKeyComparator() {
        return this.keyComparator;
    }

    public void setKeyComparator(Comparator<K> keyComparator) {
        this.keyComparator = keyComparator;
    }

    public boolean isDeduplicate() {
        return this.deduplicate;
    }

    public void setDeduplicate(boolean deduplicate) {
        this.deduplicate = deduplicate;
    }

    public int getItemsInMemorySize() {
        return this.itemsInMemorySize;
    }

    public void setItemsInMemorySize(int itemsInMemorySize) {
        this.itemsInMemorySize = itemsInMemorySize;
    }

    public StreamId getInput() {
        return this.input;
    }

    public void setInput(StreamId input) {
        this.input = input;
    }

    public StreamId getOutput() {
        return this.output;
    }

    public void setOutput(StreamId output) {
        this.output = output;
    }
}

