/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.datagraph.node;

import io.datakernel.datagraph.graph.StreamId;
import io.datakernel.datagraph.graph.TaskContext;
import io.datakernel.datagraph.node.Node;
import io.datakernel.stream.processor.StreamUnion;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class NodeUnion<T>
implements Node {
    private List<StreamId> inputs;
    private StreamId output;

    public NodeUnion() {
    }

    public NodeUnion(List<StreamId> inputs) {
        this.inputs = inputs;
        this.output = new StreamId();
    }

    @Override
    public Collection<StreamId> getOutputs() {
        return Collections.singletonList(this.output);
    }

    @Override
    public void createAndBind(TaskContext taskContext) {
        StreamUnion streamUnion = StreamUnion.create();
        for (StreamId input : this.inputs) {
            taskContext.bindChannel(input, streamUnion.newInput());
        }
        taskContext.export(this.output, streamUnion.getOutput());
    }

    public List<StreamId> getInputs() {
        return this.inputs;
    }

    public void setInputs(List<StreamId> inputs) {
        this.inputs = inputs;
    }

    public StreamId getOutput() {
        return this.output;
    }

    public void setOutput(StreamId output) {
        this.output = output;
    }

    public String toString() {
        return "NodeUnion{inputs=" + this.inputs + ", output=" + this.output + '}';
    }
}

