/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.datagraph.node;

import io.datakernel.datagraph.graph.StreamId;
import io.datakernel.datagraph.graph.TaskContext;
import io.datakernel.datagraph.node.Node;
import io.datakernel.datagraph.server.DatagraphServer;
import java.util.Collection;
import java.util.Collections;

public final class NodeUpload<T>
implements Node {
    private Class<T> type;
    private StreamId streamId;

    public NodeUpload() {
    }

    public NodeUpload(Class<T> type, StreamId streamId) {
        this.type = type;
        this.streamId = streamId;
    }

    @Override
    public Collection<StreamId> getOutputs() {
        return Collections.emptyList();
    }

    @Override
    public void createAndBind(TaskContext taskContext) {
        DatagraphServer server = taskContext.environment().getInstance(DatagraphServer.class);
        taskContext.bindChannel(this.streamId, server.upload(this.streamId, this.type));
    }

    public Class<T> getType() {
        return this.type;
    }

    public void setType(Class<T> type) {
        this.type = type;
    }

    public StreamId getStreamId() {
        return this.streamId;
    }

    public void setStreamId(StreamId streamId) {
        this.streamId = streamId;
    }

    public String toString() {
        return "NodeUpload{type=" + this.type + ", streamId=" + this.streamId + '}';
    }
}

