/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.datagraph.server;

import io.datakernel.datagraph.dataset.Dataset;
import io.datakernel.datagraph.graph.DataGraph;
import io.datakernel.datagraph.graph.Partition;
import io.datakernel.datagraph.graph.StreamId;
import io.datakernel.datagraph.node.NodeUpload;
import io.datakernel.datagraph.server.DatagraphClient;
import io.datakernel.eventloop.Eventloop;
import io.datakernel.stream.StreamProducer;
import java.util.ArrayList;
import java.util.List;

public final class Collector<T> {
    private final Dataset<T> input;
    private final Class<T> type;
    private final DatagraphClient client;
    private final Eventloop eventloop;

    public Collector(Dataset<T> input, Class<T> type, DatagraphClient client, Eventloop eventloop) {
        this.input = input;
        this.type = type;
        this.client = client;
        this.eventloop = eventloop;
    }

    public StreamProducer<T> compile(DataGraph dataGraph) {
        List<StreamId> inputStreamIds = this.input.channels(dataGraph);
        ArrayList<StreamProducer> producers = new ArrayList<StreamProducer>();
        for (StreamId streamId : inputStreamIds) {
            NodeUpload<T> nodeUpload = new NodeUpload<T>(this.type, streamId);
            Partition partition = dataGraph.getPartition(streamId);
            dataGraph.addNode(partition, nodeUpload);
            StreamProducer producer = StreamProducer.ofStage(this.client.download(partition.getAddress(), streamId, this.type));
            producers.add(producer);
        }
        return StreamProducer.concat(producers);
    }
}

