/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.datagraph.server;

import com.google.gson.TypeAdapter;
import io.datakernel.codegen.DefiningClassLoader;
import io.datakernel.datagraph.graph.StreamId;
import io.datakernel.datagraph.node.Node;
import io.datakernel.datagraph.node.NodeConsumerToList;
import io.datakernel.datagraph.node.NodeDownload;
import io.datakernel.datagraph.node.NodeFilter;
import io.datakernel.datagraph.node.NodeJoin;
import io.datakernel.datagraph.node.NodeMap;
import io.datakernel.datagraph.node.NodeMerge;
import io.datakernel.datagraph.node.NodeProducerOfIterable;
import io.datakernel.datagraph.node.NodeReduce;
import io.datakernel.datagraph.node.NodeReduceSimple;
import io.datakernel.datagraph.node.NodeShard;
import io.datakernel.datagraph.node.NodeSort;
import io.datakernel.datagraph.node.NodeUnion;
import io.datakernel.datagraph.node.NodeUpload;
import io.datakernel.datagraph.server.command.DatagraphCommand;
import io.datakernel.datagraph.server.command.DatagraphCommandDownload;
import io.datakernel.datagraph.server.command.DatagraphCommandExecute;
import io.datakernel.datagraph.server.command.DatagraphResponse;
import io.datakernel.datagraph.server.command.DatagraphResponseAck;
import io.datakernel.datagraph.server.command.DatagraphResponseDisconnect;
import io.datakernel.datagraph.server.command.DatagraphResponseExecute;
import io.datakernel.serializer.BufferSerializer;
import io.datakernel.serializer.SerializerBuilder;
import io.datakernel.stream.processor.Sharder;
import io.datakernel.stream.processor.Sharders;
import io.datakernel.stream.processor.StreamJoin;
import io.datakernel.stream.processor.StreamMap;
import io.datakernel.stream.processor.StreamReducers;
import io.datakernel.util.Preconditions;
import io.datakernel.util.gson.GsonAdapters;
import io.datakernel.util.gson.TypeAdapterObject;
import io.datakernel.util.gson.TypeAdapterObjectSubtype;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DatagraphSerialization {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final TypeAdapter<StreamId> STREAM_ID_JSON = GsonAdapters.transform((TypeAdapter)GsonAdapters.LONG_JSON, StreamId::new, StreamId::getId).nullSafe();
    public static final TypeAdapter<InetSocketAddress> ADDRESS_JSON = GsonAdapters.transform((TypeAdapter)GsonAdapters.STRING_JSON, str -> {
        String[] split = str.split(":");
        Preconditions.checkArgument((split.length == 2 ? 1 : 0) != 0);
        return new InetSocketAddress(InetAddress.getByName(split[0]), Integer.parseInt(split[1]));
    }, addr -> addr.getAddress().getHostAddress() + ':' + addr.getPort()).nullSafe();
    public static final TypeAdapter<Predicate<Object>> PREDICATE_JSON = GsonAdapters.stateless();
    public static final TypeAdapter<Function<Object, Object>> FUNCTION_JSON = GsonAdapters.stateless((Object[])new Function[]{Function.identity()});
    public static final TypeAdapter<Comparator<Object>> COMPARATOR_JSON = GsonAdapters.stateless();
    public static final TypeAdapterObjectSubtype<Sharder> SHARDER_JSON = TypeAdapterObjectSubtype.create().withSubtype(Sharders.HashSharder.class, "HashSharder", (TypeAdapter)TypeAdapterObject.create(Sharders.HashSharder::new).with("partitions", GsonAdapters.INTEGER_JSON, Sharders.HashSharder::getPartitions, Sharders.HashSharder::setPartitions)).allOtherAreStateless();
    public static final TypeAdapter<StreamMap.Mapper<Object, Object>> MAPPER_JSON = GsonAdapters.stateless();
    public static final TypeAdapter<StreamJoin.Joiner<Object, Object, Object, Object>> JOINER_JSON = GsonAdapters.stateless();
    public static final TypeAdapter<StreamReducers.ReducerToResult> REDUCER_TO_RESULT_JSON = GsonAdapters.stateless();
    public static final TypeAdapterObjectSubtype<StreamReducers.Reducer> REDUCER_JSON = TypeAdapterObjectSubtype.create().withSubtype(StreamReducers.ReducerToResult.InputToAccumulator.class, "InputToAccumulator", (TypeAdapter)TypeAdapterObject.create(StreamReducers.ReducerToResult.InputToAccumulator::new).with("reducerToResult", REDUCER_TO_RESULT_JSON, StreamReducers.ReducerToResult.InputToAccumulator::getReducerToResult, StreamReducers.ReducerToResult.InputToAccumulator::setReducerToResult)).withSubtype(StreamReducers.ReducerToResult.InputToOutput.class, "InputToOutput", (TypeAdapter)TypeAdapterObject.create(StreamReducers.ReducerToResult.InputToOutput::new).with("reducerToResult", REDUCER_TO_RESULT_JSON, StreamReducers.ReducerToResult.InputToOutput::getReducerToResult, StreamReducers.ReducerToResult.InputToOutput::setReducerToResult)).withSubtype(StreamReducers.ReducerToResult.AccumulatorToAccumulator.class, "AccumulatorToAccumulator", (TypeAdapter)TypeAdapterObject.create(StreamReducers.ReducerToResult.AccumulatorToAccumulator::new).with("reducerToResult", REDUCER_TO_RESULT_JSON, StreamReducers.ReducerToResult.AccumulatorToAccumulator::getReducerToResult, StreamReducers.ReducerToResult.AccumulatorToAccumulator::setReducerToResult)).withSubtype(StreamReducers.ReducerToResult.AccumulatorToOutput.class, "AccumulatorToOutput", (TypeAdapter)TypeAdapterObject.create(StreamReducers.ReducerToResult.AccumulatorToOutput::new).with("reducerToResult", REDUCER_TO_RESULT_JSON, StreamReducers.ReducerToResult.AccumulatorToOutput::getReducerToResult, StreamReducers.ReducerToResult.AccumulatorToOutput::setReducerToResult)).withStatelessSubtype(StreamReducers.MergeDeduplicateReducer::new, "MergeDeduplicateReducer").withStatelessSubtype(StreamReducers.MergeSortReducer::new, "MergeSortReducer").allOtherAreStateless();
    public static final TypeAdapterObjectSubtype<Node> NODE_JSON = TypeAdapterObjectSubtype.create().withSubtype(NodeDownload.class, "Download", (TypeAdapter)TypeAdapterObject.create(NodeDownload::new).with("type", GsonAdapters.CLASS_JSON, NodeDownload::getType, NodeDownload::setType).with("address", ADDRESS_JSON, NodeDownload::getAddress, NodeDownload::setAddress).with("streamId", STREAM_ID_JSON, NodeDownload::getStreamId, NodeDownload::setStreamId).with("output", STREAM_ID_JSON, NodeDownload::getOutput, NodeDownload::setOutput)).withSubtype(NodeUpload.class, "Upload", (TypeAdapter)TypeAdapterObject.create(NodeUpload::new).with("type", GsonAdapters.CLASS_JSON, NodeUpload::getType, NodeUpload::setType).with("streamId", STREAM_ID_JSON, NodeUpload::getStreamId, NodeUpload::setStreamId)).withSubtype(NodeMap.class, "Map", (TypeAdapter)TypeAdapterObject.create(NodeMap::new).with("mapper", MAPPER_JSON, NodeMap::getMapper, NodeMap::setMapper).with("input", STREAM_ID_JSON, NodeMap::getInput, NodeMap::setInput).with("output", STREAM_ID_JSON, NodeMap::getOutput, NodeMap::setOutput)).withSubtype(NodeFilter.class, "Filter", (TypeAdapter)TypeAdapterObject.create(NodeFilter::new).with("predicate", PREDICATE_JSON, NodeFilter::getPredicate, NodeFilter::setPredicate).with("input", STREAM_ID_JSON, NodeFilter::getInput, NodeFilter::setInput).with("output", STREAM_ID_JSON, NodeFilter::getOutput, NodeFilter::setOutput)).withSubtype(NodeSort.class, "Sort", (TypeAdapter)TypeAdapterObject.create(NodeSort::new).with("keyFunction", FUNCTION_JSON, NodeSort::getKeyFunction, NodeSort::setKeyFunction).with("keyComparator", COMPARATOR_JSON, NodeSort::getKeyComparator, NodeSort::setKeyComparator).with("deduplicate", GsonAdapters.BOOLEAN_JSON, NodeSort::isDeduplicate, NodeSort::setDeduplicate).with("itemsInMemorySize", GsonAdapters.INTEGER_JSON, NodeSort::getItemsInMemorySize, NodeSort::setItemsInMemorySize).with("input", STREAM_ID_JSON, NodeSort::getInput, NodeSort::setInput).with("output", STREAM_ID_JSON, NodeSort::getOutput, NodeSort::setOutput)).withSubtype(NodeShard.class, "Shard", (TypeAdapter)TypeAdapterObject.create(NodeShard::new).with("keyFunction", FUNCTION_JSON, NodeShard::getKeyFunction, NodeShard::setKeyFunction).with("input", STREAM_ID_JSON, NodeShard::getInput, NodeShard::setInput).with("outputs", GsonAdapters.ofList(STREAM_ID_JSON), NodeShard::getOutputs, NodeShard::setOutputs)).withSubtype(NodeMerge.class, "Merge", (TypeAdapter)TypeAdapterObject.create(NodeMerge::new).with("keyFunction", FUNCTION_JSON, NodeMerge::getKeyFunction, NodeMerge::setKeyFunction).with("keyComparator", COMPARATOR_JSON, NodeMerge::getKeyComparator, NodeMerge::setKeyComparator).with("deduplicate", GsonAdapters.BOOLEAN_JSON, NodeMerge::isDeduplicate, NodeMerge::setDeduplicate).with("inputs", GsonAdapters.ofList(STREAM_ID_JSON), NodeMerge::getInputs, NodeMerge::setInputs).with("output", STREAM_ID_JSON, NodeMerge::getOutput, NodeMerge::setOutput)).withSubtype(NodeReduce.class, "Reduce", (TypeAdapter)TypeAdapterObject.create(NodeReduce::new).with("keyComparator", COMPARATOR_JSON, NodeReduce::getKeyComparator, NodeReduce::setKeyComparator).with("output", STREAM_ID_JSON, NodeReduce::getOutput, NodeReduce::setOutput).with("inputs", GsonAdapters.ofMap(s -> Long.toString(s.getId()), s -> new StreamId(Long.parseLong(s)), (TypeAdapter)TypeAdapterObject.create(NodeReduce.Input::new).with("reducer", REDUCER_JSON, NodeReduce.Input::getReducer, (obj, reducer) -> obj.setReducer(reducer)).with("keyFunction", FUNCTION_JSON, obj -> obj.getKeyFunction(), NodeReduce.Input::setKeyFunction)), NodeReduce::getInputs, NodeReduce::setInputs)).withSubtype(NodeReduceSimple.class, "ReduceSimple", (TypeAdapter)TypeAdapterObject.create(NodeReduceSimple::new).with("keyFunction", FUNCTION_JSON, NodeReduceSimple::getKeyFunction, NodeReduceSimple::setKeyFunction).with("keyComparator", COMPARATOR_JSON, NodeReduceSimple::getKeyComparator, NodeReduceSimple::setKeyComparator).with("reducer", REDUCER_JSON, NodeReduceSimple::getReducer, (obj, reducer) -> obj.setReducer(reducer)).with("inputs", GsonAdapters.ofList(STREAM_ID_JSON), NodeReduceSimple::getInputs, NodeReduceSimple::setInputs).with("output", STREAM_ID_JSON, NodeReduceSimple::getOutput, NodeReduceSimple::setOutput)).withSubtype(NodeJoin.class, "Join", (TypeAdapter)TypeAdapterObject.create(NodeJoin::new).with("left", STREAM_ID_JSON, NodeJoin::getLeft, NodeJoin::setLeft).with("right", STREAM_ID_JSON, NodeJoin::getRight, NodeJoin::setRight).with("output", STREAM_ID_JSON, NodeJoin::getOutput, NodeJoin::setOutput).with("keyComparator", COMPARATOR_JSON, NodeJoin::getKeyComparator, NodeJoin::setKeyComparator).with("leftKeyFunction", FUNCTION_JSON, NodeJoin::getLeftKeyFunction, NodeJoin::setLeftKeyFunction).with("rightKeyFunction", FUNCTION_JSON, NodeJoin::getRightKeyFunction, NodeJoin::setRightKeyFunction).with("joiner", JOINER_JSON, NodeJoin::getJoiner, NodeJoin::setJoiner)).withSubtype(NodeUnion.class, "Union", (TypeAdapter)TypeAdapterObject.create(NodeUnion::new).with("inputs", GsonAdapters.ofList(STREAM_ID_JSON), NodeUnion::getInputs, NodeUnion::setInputs).with("output", STREAM_ID_JSON, NodeUnion::getOutput, NodeUnion::setOutput)).withSubtype(NodeProducerOfIterable.class, "ProducerOfIterable", (TypeAdapter)TypeAdapterObject.create(NodeProducerOfIterable::new).with("iterableId", GsonAdapters.STRING_JSON, t1 -> (String)t1.getIterableId(), NodeProducerOfIterable::setIterableId).with("output", STREAM_ID_JSON, NodeProducerOfIterable::getOutput, NodeProducerOfIterable::setOutput)).withSubtype(NodeConsumerToList.class, "ConsumerToList", (TypeAdapter)TypeAdapterObject.create(NodeConsumerToList::new).with("iterableId", GsonAdapters.STRING_JSON, t -> (String)t.getListId(), NodeConsumerToList::setListId).with("input", STREAM_ID_JSON, NodeConsumerToList::getInput, NodeConsumerToList::setInput));
    public static final TypeAdapterObjectSubtype<DatagraphCommand> COMMAND_JSON = TypeAdapterObjectSubtype.create().withSubtype(DatagraphCommandDownload.class, "Download", (TypeAdapter)TypeAdapterObject.create(DatagraphCommandDownload::new).with("streamId", STREAM_ID_JSON, DatagraphCommandDownload::getStreamId, DatagraphCommandDownload::setStreamId)).withSubtype(DatagraphCommandExecute.class, "Execute", (TypeAdapter)TypeAdapterObject.create(DatagraphCommandExecute::new).with("nodes", GsonAdapters.ofList(NODE_JSON), DatagraphCommandExecute::getNodes, DatagraphCommandExecute::setNodes));
    public static final TypeAdapterObjectSubtype<DatagraphResponse> RESONSE_JSON = TypeAdapterObjectSubtype.create().withStatelessSubtype(DatagraphResponseAck::new, "Ack").withStatelessSubtype(DatagraphResponseDisconnect::new, "Disconnect").withSubtype(DatagraphResponseExecute.class, "Execute", (TypeAdapter)TypeAdapterObject.create(DatagraphResponseExecute::new).with("nodeIds", GsonAdapters.ofList((TypeAdapter)GsonAdapters.INTEGER_JSON), DatagraphResponseExecute::getNodeIds, DatagraphResponseExecute::setNodeIds));
    public final TypeAdapter<DatagraphCommand> commandAdapter;
    public final TypeAdapter<DatagraphResponse> responseAdapter;
    public final TypeAdapter<Node> nodeAdapter;
    private final Map<Class<?>, BufferSerializer<?>> serializers = new HashMap();

    private DatagraphSerialization(TypeAdapter<DatagraphCommand> commandAdapter, TypeAdapter<DatagraphResponse> responseAdapter, TypeAdapter<Node> nodeAdapter) {
        this.commandAdapter = commandAdapter;
        this.responseAdapter = responseAdapter;
        this.nodeAdapter = nodeAdapter;
    }

    public static DatagraphSerialization create() {
        return new DatagraphSerialization((TypeAdapter<DatagraphCommand>)COMMAND_JSON, (TypeAdapter<DatagraphResponse>)RESONSE_JSON, (TypeAdapter<Node>)NODE_JSON);
    }

    public DatagraphSerialization withNodeAdapter(TypeAdapter<Node> nodeAdapter) {
        return new DatagraphSerialization(this.commandAdapter, this.responseAdapter, nodeAdapter);
    }

    public DatagraphSerialization withMessagingAdapters(TypeAdapter<DatagraphCommand> commandAdapter, TypeAdapter<DatagraphResponse> responseAdapter) {
        return new DatagraphSerialization(commandAdapter, responseAdapter, this.nodeAdapter);
    }

    public synchronized <T> BufferSerializer<T> getSerializer(Class<T> type) {
        BufferSerializer serializer = this.serializers.get(type);
        if (serializer == null) {
            this.logger.info("Creating serializer for {}", type);
            serializer = SerializerBuilder.create((DefiningClassLoader)DefiningClassLoader.create((ClassLoader)ClassLoader.getSystemClassLoader())).build(type);
            this.serializers.put(type, serializer);
        }
        return serializer;
    }
}

