/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.stream;

import io.datakernel.annotation.Nullable;
import io.datakernel.async.SettableStage;
import io.datakernel.async.Stage;
import io.datakernel.eventloop.Eventloop;
import io.datakernel.exception.ExpectedException;
import io.datakernel.stream.StreamCapability;
import io.datakernel.stream.StreamConsumer;
import io.datakernel.stream.StreamProducer;
import io.datakernel.stream.StreamStatus;
import io.datakernel.util.Preconditions;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStreamConsumer<T>
implements StreamConsumer<T> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final Eventloop eventloop = Eventloop.getCurrentEventloop();
    private final long createTick = this.eventloop.getTick();
    private StreamProducer<T> producer;
    private StreamStatus status = StreamStatus.OPEN;
    private Throwable exception;
    private final SettableStage<Void> endOfStream = SettableStage.create();
    private Object tag;

    @Override
    public final void setProducer(StreamProducer<T> producer) {
        Preconditions.checkNotNull(producer);
        Preconditions.checkState((this.producer == null ? 1 : 0) != 0);
        Preconditions.checkState((this.getCapabilities().contains((Object)StreamCapability.LATE_BINDING) || this.eventloop.getTick() == this.createTick ? 1 : 0) != 0, (String)"StreamConsumer %s does not have LATE_BINDING capabilities, it must be bound in the same tick when it is created. Alternatively, use .withLateBinding() modifier", (Object[])new Object[]{this});
        this.producer = producer;
        this.onWired();
        producer.getEndOfStream().thenRun(this::endOfStream).whenException(this::closeWithError);
    }

    protected void onWired() {
        this.eventloop.post(this::onStarted);
    }

    protected void onStarted() {
    }

    public boolean isWired() {
        return this.producer != null;
    }

    @Nullable
    public final StreamProducer<T> getProducer() {
        return this.producer;
    }

    protected final void endOfStream() {
        if (this.status.isClosed()) {
            return;
        }
        this.status = StreamStatus.END_OF_STREAM;
        this.onEndOfStream();
        this.eventloop.post(this::cleanup);
        this.endOfStream.set(null);
    }

    protected abstract void onEndOfStream();

    public final void closeWithError(Throwable t) {
        if (this.status.isClosed()) {
            return;
        }
        this.status = StreamStatus.CLOSED_WITH_ERROR;
        this.exception = t;
        if (!(t instanceof ExpectedException) && this.logger.isWarnEnabled()) {
            this.logger.warn("StreamConsumer {} closed with error {}", (Object)this, (Object)t.toString());
        }
        this.onError(t);
        this.eventloop.post(this::cleanup);
        this.endOfStream.setException(t);
    }

    protected abstract void onError(Throwable var1);

    protected void cleanup() {
    }

    public final StreamStatus getStatus() {
        return this.status;
    }

    public final Throwable getException() {
        return this.exception;
    }

    @Override
    public final Stage<Void> getEndOfStream() {
        return this.endOfStream;
    }

    protected static Set<StreamCapability> addCapabilities(@Nullable StreamConsumer<?> consumer, StreamCapability capability, StreamCapability ... capabilities) {
        EnumSet<StreamCapability[]> result = EnumSet.of(capability, capabilities);
        if (consumer != null) {
            result.addAll(consumer.getCapabilities());
        }
        return result;
    }

    @Override
    public Set<StreamCapability> getCapabilities() {
        return Collections.emptySet();
    }

    public final Object getTag() {
        return this.tag;
    }

    public final void setTag(Object tag) {
        this.tag = tag;
    }

    public String toString() {
        return this.tag != null ? this.tag.toString() : super.toString();
    }
}

