/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.stream;

import io.datakernel.stream.StreamConsumer;
import io.datakernel.stream.StreamConsumerWithResult;
import java.util.List;

public interface StreamConsumerModifier<T, R> {
    public StreamConsumer<R> applyTo(StreamConsumer<T> var1);

    default public <X> StreamConsumerWithResult<R, X> applyTo(StreamConsumerWithResult<T, X> consumer) {
        return this.applyTo((StreamConsumer<T>)consumer).withResult(consumer.getResult());
    }

    default public <X> StreamConsumerModifier<T, X> then(StreamConsumerModifier<R, X> nextModifier) {
        return consumer -> nextModifier.applyTo(this.applyTo(consumer));
    }

    public static <T> StreamConsumerModifier<T, T> identity() {
        return consumer -> consumer;
    }

    public static <T> StreamConsumerModifier<T, T> of(List<StreamConsumerModifier<T, T>> modifiers) {
        return consumer -> {
            for (StreamConsumerModifier modifier : modifiers) {
                consumer = modifier.applyTo(consumer);
            }
            return consumer;
        };
    }
}

