/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.stream;

import io.datakernel.async.SettableStage;
import io.datakernel.async.Stage;
import io.datakernel.stream.AbstractStreamConsumer;
import io.datakernel.stream.StreamCapability;
import io.datakernel.stream.StreamConsumerWithResult;
import io.datakernel.stream.StreamDataReceiver;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public final class StreamConsumerToList<T>
extends AbstractStreamConsumer<T>
implements StreamConsumerWithResult<T, List<T>>,
StreamDataReceiver<T> {
    protected final List<T> list;
    private final SettableStage<List<T>> resultStage = SettableStage.create();

    private StreamConsumerToList() {
        this(new ArrayList());
    }

    private StreamConsumerToList(List<T> list) {
        this.list = list;
    }

    public static <T> StreamConsumerToList<T> create() {
        return new StreamConsumerToList<T>();
    }

    public static <T> StreamConsumerToList<T> create(List<T> list) {
        return new StreamConsumerToList<T>(list);
    }

    @Override
    public void onData(T item) {
        this.list.add(item);
    }

    @Override
    protected void onStarted() {
        this.getProducer().produce(this);
    }

    @Override
    protected void onEndOfStream() {
        this.resultStage.set(this.list);
    }

    @Override
    protected void onError(Throwable t) {
        this.resultStage.setException(t);
    }

    @Override
    public final Stage<List<T>> getResult() {
        return this.resultStage;
    }

    public final List<T> getList() {
        return this.list;
    }

    @Override
    public Set<StreamCapability> getCapabilities() {
        return EnumSet.of(StreamCapability.LATE_BINDING);
    }
}

