/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.stream;

import io.datakernel.async.SettableStage;
import io.datakernel.async.Stage;
import io.datakernel.async.StageConsumer;
import io.datakernel.stream.DataStreams;
import io.datakernel.stream.StreamCapability;
import io.datakernel.stream.StreamConsumer;
import io.datakernel.stream.StreamConsumerModifier;
import io.datakernel.stream.StreamConsumerToCollector;
import io.datakernel.stream.processor.StreamLateBinder;
import io.datakernel.util.Preconditions;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public interface StreamConsumerWithResult<T, X>
extends StreamConsumer<T> {
    public Stage<X> getResult();

    default public <R> StreamConsumerWithResult<R, X> with(StreamConsumerModifier<T, R> modifier) {
        return modifier.applyTo(this).withResult(this.getResult());
    }

    default public StreamConsumerWithResult<T, X> withLateBinding() {
        return this.getCapabilities().contains((Object)StreamCapability.LATE_BINDING) ? this : this.with((StreamConsumerModifier)StreamLateBinder.create());
    }

    public static <T, X> StreamConsumerWithResult<T, X> ofStage(Stage<StreamConsumerWithResult<T, X>> consumerStage) {
        SettableStage result = SettableStage.create();
        StreamLateBinder binder = StreamLateBinder.create();
        consumerStage.whenComplete((consumer, throwable) -> {
            if (throwable == null) {
                Preconditions.checkArgument((boolean)consumer.getCapabilities().contains((Object)StreamCapability.LATE_BINDING), (String)"StreamConsumer %s does not have LATE_BINDING capabilities, it must be bound in the same tick when it is created. Alternatively, use .withLateBinding() modifier", (Object[])new Object[]{consumer});
                DataStreams.bind(binder.getOutput(), consumer);
                consumer.getResult().whenComplete((arg_0, arg_1) -> ((SettableStage)result).set(arg_0, arg_1));
            } else {
                DataStreams.bind(binder.getOutput(), StreamConsumer.closingWithError(throwable));
                result.setException(throwable);
            }
        });
        return binder.getInput().withResult(result);
    }

    default public <U> StreamConsumerWithResult<T, U> thenApply(Function<? super X, ? extends U> fn) {
        return this.withResult(this.getResult().post().thenApply(fn));
    }

    default public <U> StreamConsumerWithResult<T, U> thenApplyEx(BiFunction<? super X, Throwable, ? extends U> fn) {
        return this.withResult(this.getResult().post().thenApplyEx(fn));
    }

    default public StreamConsumerWithResult<T, X> thenRun(Runnable action) {
        this.getResult().post().thenRun(action);
        return this;
    }

    default public StreamConsumerWithResult<T, X> thenRunEx(Runnable action) {
        this.getResult().post().thenRunEx(action);
        return this;
    }

    default public <U> StreamConsumerWithResult<T, U> thenCompose(Function<? super X, ? extends Stage<U>> fn) {
        return this.withResult(this.getResult().post().thenCompose(fn));
    }

    default public <U> StreamConsumerWithResult<T, U> thenComposeEx(BiFunction<? super X, Throwable, ? extends Stage<U>> fn) {
        return this.withResult(this.getResult().post().thenComposeEx(fn));
    }

    default public StreamConsumerWithResult<T, X> whenComplete(StageConsumer<? super X> consumer) {
        this.getResult().post().whenComplete(consumer);
        return this;
    }

    default public StreamConsumerWithResult<T, X> whenResult(Consumer<? super X> action) {
        this.getResult().post().whenResult(action);
        return this;
    }

    default public StreamConsumerWithResult<T, X> whenException(Consumer<Throwable> consumer) {
        this.getResult().post().whenException(consumer);
        return this;
    }

    public static <T> StreamConsumerWithResult<T, List<T>> toList() {
        return StreamConsumerWithResult.toCollector(Collectors.toList());
    }

    public static <T, A, R> StreamConsumerWithResult<T, R> toCollector(Collector<T, A, R> collector) {
        return new StreamConsumerToCollector<T, A, R>(collector);
    }
}

