/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.stream;

import io.datakernel.async.SettableStage;
import io.datakernel.async.Stage;
import io.datakernel.async.Stages;
import io.datakernel.stream.DataStreams;
import io.datakernel.stream.StreamCapability;
import io.datakernel.stream.StreamCompletion;
import io.datakernel.stream.StreamConsumer;
import io.datakernel.stream.StreamConsumerResult;
import io.datakernel.stream.StreamConsumerWithResult;
import io.datakernel.stream.StreamDataReceiver;
import io.datakernel.stream.StreamProducerConcat;
import io.datakernel.stream.StreamProducerModifier;
import io.datakernel.stream.StreamProducerWithResult;
import io.datakernel.stream.StreamProducers;
import io.datakernel.stream.processor.StreamLateBinder;
import io.datakernel.util.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface StreamProducer<T> {
    public static final String LATE_BINDING_ERROR_MESSAGE = "StreamProducer %s does not have LATE_BINDING capabilities, it must be bound in the same tick when it is created. Alternatively, use .withLateBinding() modifier";

    public void setConsumer(StreamConsumer<T> var1);

    public void produce(StreamDataReceiver<T> var1);

    public void suspend();

    public Stage<Void> getEndOfStream();

    public Set<StreamCapability> getCapabilities();

    default public StreamCompletion streamTo(StreamConsumer<T> consumer) {
        StreamProducer producer = this;
        DataStreams.bind(producer, consumer);
        final Stage<Void> producerEndOfStream = producer.getEndOfStream();
        final Stage<Void> consumerEndOfStream = consumer.getEndOfStream();
        final Stage endOfStream = Stages.all(producerEndOfStream, consumerEndOfStream);
        return new StreamCompletion(){

            @Override
            public Stage<Void> getProducerEndOfStream() {
                return producerEndOfStream;
            }

            @Override
            public Stage<Void> getConsumerEndOfStream() {
                return consumerEndOfStream;
            }

            @Override
            public Stage<Void> getEndOfStream() {
                return endOfStream;
            }
        };
    }

    default public <Y> StreamConsumerResult<Y> streamTo(StreamConsumerWithResult<T, Y> consumer) {
        StreamProducer producer = this;
        DataStreams.bind(producer, consumer);
        final Stage<Void> producerEndOfStream = producer.getEndOfStream();
        final Stage<Void> consumerEndOfStream = consumer.getEndOfStream();
        final Stage endOfStream = Stages.all(producerEndOfStream, consumerEndOfStream);
        final Stage<Y> consumerResult = consumer.getResult();
        return new StreamConsumerResult<Y>(){

            @Override
            public Stage<Y> getConsumerResult() {
                return consumerResult;
            }

            @Override
            public Stage<Void> getProducerEndOfStream() {
                return producerEndOfStream;
            }

            @Override
            public Stage<Void> getConsumerEndOfStream() {
                return consumerEndOfStream;
            }

            @Override
            public Stage<Void> getEndOfStream() {
                return endOfStream;
            }
        };
    }

    default public <R> StreamProducer<R> with(StreamProducerModifier<T, R> modifier) {
        return modifier.applyTo(this);
    }

    default public StreamProducer<T> withLateBinding() {
        return this.getCapabilities().contains((Object)StreamCapability.LATE_BINDING) ? this : this.with(StreamLateBinder.create());
    }

    public static <T> StreamProducer<T> idle() {
        return new StreamProducers.IdleImpl();
    }

    public static <T> StreamProducer<T> closing() {
        return new StreamProducers.ClosingImpl();
    }

    public static <T> StreamProducer<T> closingWithError(Throwable t) {
        return new StreamProducers.ClosingWithErrorImpl(t);
    }

    @SafeVarargs
    public static <T> StreamProducer<T> of(T ... values) {
        return new StreamProducers.OfIteratorImpl<T>(Arrays.asList(values).iterator());
    }

    public static <T> StreamProducer<T> ofIterator(Iterator<T> iterator) {
        return new StreamProducers.OfIteratorImpl<T>(iterator);
    }

    public static <T> StreamProducer<T> ofIterable(Iterable<T> iterable) {
        return new StreamProducers.OfIteratorImpl<T>(iterable.iterator());
    }

    public static <T> StreamProducer<T> ofStream(Stream<T> stream) {
        return new StreamProducers.OfIteratorImpl(stream.iterator());
    }

    public static <T> StreamProducer<T> ofSupplier(final Supplier<T> supplier) {
        return new StreamProducers.OfIteratorImpl(new Iterator<T>(){
            private T next;
            {
                this.next = supplier.get();
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public T next() {
                Object n = this.next;
                this.next = supplier.get();
                return n;
            }
        });
    }

    public static <T> StreamProducer<T> ofStage(Stage<StreamProducer<T>> producerStage) {
        StreamLateBinder binder = StreamLateBinder.create();
        producerStage.whenComplete((producer, throwable) -> {
            if (throwable == null) {
                Preconditions.checkArgument((boolean)producer.getCapabilities().contains((Object)StreamCapability.LATE_BINDING), (String)LATE_BINDING_ERROR_MESSAGE, (Object[])new Object[]{producer});
                DataStreams.bind(producer, binder.getInput());
            } else {
                DataStreams.bind(StreamProducer.closingWithError(throwable), binder.getInput());
            }
        });
        return binder.getOutput();
    }

    public static <T> StreamProducer<T> concat(Iterator<StreamProducer<T>> iterator) {
        return new StreamProducerConcat<T>(iterator);
    }

    public static <T> StreamProducer<T> concat(List<StreamProducer<T>> producers) {
        return StreamProducer.concat(producers.iterator());
    }

    @SafeVarargs
    public static <T> StreamProducer<T> concat(StreamProducer<T> ... producers) {
        return StreamProducer.concat(Arrays.asList(producers));
    }

    default public <X> StreamProducerWithResult<T, X> withResult(Stage<X> result) {
        final SettableStage safeEndOfStream = SettableStage.create();
        final SettableStage safeResult = SettableStage.create();
        this.getEndOfStream().whenComplete(($, throwable) -> {
            safeEndOfStream.trySet($, throwable);
            if (throwable != null) {
                safeResult.trySetException(throwable);
            }
        });
        result.post().whenComplete((arg_0, arg_1) -> ((SettableStage)safeResult).trySet(arg_0, arg_1));
        return new StreamProducerWithResult<T, X>(){

            @Override
            public void setConsumer(StreamConsumer<T> consumer) {
                StreamProducer.this.setConsumer(consumer);
            }

            @Override
            public void produce(StreamDataReceiver<T> dataReceiver) {
                StreamProducer.this.produce(dataReceiver);
            }

            @Override
            public void suspend() {
                StreamProducer.this.suspend();
            }

            @Override
            public Stage<Void> getEndOfStream() {
                return safeEndOfStream;
            }

            @Override
            public Stage<X> getResult() {
                return safeResult;
            }

            @Override
            public Set<StreamCapability> getCapabilities() {
                return StreamProducer.this.getCapabilities().contains((Object)StreamCapability.LATE_BINDING) ? EnumSet.of(StreamCapability.LATE_BINDING) : Collections.emptySet();
            }
        };
    }

    default public StreamProducerWithResult<T, Void> withEndOfStreamAsResult() {
        final SettableStage safeEndOfStream = SettableStage.create();
        this.getEndOfStream().post().whenComplete((arg_0, arg_1) -> ((SettableStage)safeEndOfStream).trySet(arg_0, arg_1));
        return new StreamProducerWithResult<T, Void>(){

            @Override
            public void setConsumer(StreamConsumer<T> consumer) {
                StreamProducer.this.setConsumer(consumer);
            }

            @Override
            public void produce(StreamDataReceiver<T> dataReceiver) {
                StreamProducer.this.produce(dataReceiver);
            }

            @Override
            public void suspend() {
                StreamProducer.this.suspend();
            }

            @Override
            public Stage<Void> getEndOfStream() {
                return safeEndOfStream;
            }

            @Override
            public Stage<Void> getResult() {
                return safeEndOfStream;
            }

            @Override
            public Set<StreamCapability> getCapabilities() {
                return StreamProducer.this.getCapabilities().contains((Object)StreamCapability.LATE_BINDING) ? EnumSet.of(StreamCapability.LATE_BINDING) : Collections.emptySet();
            }
        };
    }

    default public Stage<List<T>> toList() {
        return this.toCollector(Collectors.toList());
    }

    default public <A, R> Stage<R> toCollector(Collector<T, A, R> collector) {
        return DataStreams.stream(this, StreamConsumerWithResult.toCollector(collector)).getConsumerResult();
    }
}

