/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.stream;

import io.datakernel.stream.AbstractStreamConsumer;
import io.datakernel.stream.AbstractStreamProducer;
import io.datakernel.stream.DataStreams;
import io.datakernel.stream.StreamDataReceiver;
import io.datakernel.stream.StreamProducer;
import java.util.Iterator;

class StreamProducerConcat<T>
extends AbstractStreamProducer<T> {
    private final Iterator<StreamProducer<T>> iterator;
    private StreamProducer<T> producer;
    private InternalConsumer internalConsumer;

    StreamProducerConcat(Iterator<StreamProducer<T>> iterator) {
        this.iterator = iterator;
    }

    @Override
    protected void onProduce(StreamDataReceiver<T> dataReceiver) {
        assert (dataReceiver != null);
        if (this.producer == null) {
            if (!this.iterator.hasNext()) {
                this.eventloop.post(this::sendEndOfStream);
                return;
            }
            this.producer = this.iterator.next();
            this.internalConsumer = new InternalConsumer();
            DataStreams.bind(this.producer, this.internalConsumer);
        }
        this.producer.produce(dataReceiver);
    }

    @Override
    protected void onSuspended() {
        if (this.producer != null) {
            this.producer.suspend();
        }
    }

    @Override
    protected void onError(Throwable t) {
        if (this.producer != null) {
            assert (this.internalConsumer != null);
            this.internalConsumer.closeWithError(t);
        }
    }

    @Override
    protected void cleanup() {
        this.producer = null;
    }

    private class InternalConsumer
    extends AbstractStreamConsumer<T> {
        private InternalConsumer() {
        }

        @Override
        protected void onEndOfStream() {
            this.eventloop.post(() -> {
                StreamProducerConcat.this.producer = null;
                StreamProducerConcat.this.internalConsumer = null;
                if (StreamProducerConcat.this.isReceiverReady()) {
                    StreamProducerConcat.this.onProduce(StreamProducerConcat.this.getCurrentDataReceiver());
                }
            });
        }

        @Override
        protected void onError(Throwable t) {
            StreamProducerConcat.this.closeWithError(t);
        }
    }
}

