/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.stream;

import io.datakernel.stream.StreamProducer;
import io.datakernel.stream.StreamProducerWithResult;
import java.util.List;

public interface StreamProducerModifier<T, R> {
    public StreamProducer<R> applyTo(StreamProducer<T> var1);

    default public <X> StreamProducerWithResult<R, X> applyTo(StreamProducerWithResult<T, X> producer) {
        return this.applyTo((StreamProducer<T>)producer).withResult(producer.getResult());
    }

    default public <X> StreamProducerModifier<T, X> then(StreamProducerModifier<R, X> nextModifier) {
        return producer -> nextModifier.applyTo(this.applyTo(producer));
    }

    public static <T> StreamProducerModifier<T, T> identity() {
        return producer -> producer;
    }

    public static <T> StreamProducerModifier<T, T> of(List<StreamProducerModifier<T, T>> modifiers) {
        return producer -> {
            for (StreamProducerModifier modifier : modifiers) {
                producer = modifier.applyTo(producer);
            }
            return producer;
        };
    }
}

