/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.stream;

import io.datakernel.async.SettableStage;
import io.datakernel.async.Stage;
import io.datakernel.async.StageConsumer;
import io.datakernel.async.Stages;
import io.datakernel.stream.DataStreams;
import io.datakernel.stream.StreamCapability;
import io.datakernel.stream.StreamConsumer;
import io.datakernel.stream.StreamConsumerWithResult;
import io.datakernel.stream.StreamProducer;
import io.datakernel.stream.StreamProducerModifier;
import io.datakernel.stream.StreamProducerResult;
import io.datakernel.stream.StreamResult;
import io.datakernel.stream.processor.StreamLateBinder;
import io.datakernel.util.Preconditions;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public interface StreamProducerWithResult<T, X>
extends StreamProducer<T> {
    public Stage<X> getResult();

    @Override
    default public StreamProducerResult<X> streamTo(StreamConsumer<T> consumer) {
        StreamProducerWithResult producer = this;
        DataStreams.bind(producer, consumer);
        final Stage<Void> producerEndOfStream = producer.getEndOfStream();
        final Stage<Void> consumerEndOfStream = consumer.getEndOfStream();
        final Stage endOfStream = Stages.all(producerEndOfStream, consumerEndOfStream);
        final Stage<X> producerResult = producer.getResult();
        return new StreamProducerResult<X>(){

            @Override
            public Stage<X> getProducerResult() {
                return producerResult;
            }

            @Override
            public Stage<Void> getProducerEndOfStream() {
                return producerEndOfStream;
            }

            @Override
            public Stage<Void> getConsumerEndOfStream() {
                return consumerEndOfStream;
            }

            @Override
            public Stage<Void> getEndOfStream() {
                return endOfStream;
            }
        };
    }

    default public <Y> StreamResult<X, Y> streamTo(StreamConsumerWithResult<T, Y> consumer) {
        StreamProducerWithResult producer = this;
        DataStreams.bind(producer, consumer);
        final Stage<Void> producerEndOfStream = producer.getEndOfStream();
        final Stage<Void> consumerEndOfStream = consumer.getEndOfStream();
        final Stage endOfStream = Stages.all(producerEndOfStream, consumerEndOfStream);
        final Stage result = producer.getResult().combine(consumer.getResult(), StreamResult.Pair::new);
        return new StreamResult<X, Y>(){

            @Override
            public Stage<StreamResult.Pair<X, Y>> getResult() {
                return result;
            }

            @Override
            public Stage<Void> getProducerEndOfStream() {
                return producerEndOfStream;
            }

            @Override
            public Stage<Void> getConsumerEndOfStream() {
                return consumerEndOfStream;
            }

            @Override
            public Stage<Void> getEndOfStream() {
                return endOfStream;
            }
        };
    }

    default public <R> StreamProducerWithResult<R, X> with(StreamProducerModifier<T, R> modifier) {
        return modifier.applyTo(this).withResult(this.getResult());
    }

    default public StreamProducerWithResult<T, X> withLateBinding() {
        return this.getCapabilities().contains((Object)StreamCapability.LATE_BINDING) ? this : this.with((StreamProducerModifier)StreamLateBinder.create());
    }

    public static <T, X> StreamProducerWithResult<T, X> ofStage(Stage<StreamProducerWithResult<T, X>> producerStage) {
        SettableStage result = SettableStage.create();
        StreamLateBinder binder = StreamLateBinder.create();
        producerStage.post().whenComplete((producer, throwable) -> {
            if (throwable == null) {
                Preconditions.checkArgument((boolean)producer.getCapabilities().contains((Object)StreamCapability.LATE_BINDING), (String)"StreamProducer %s does not have LATE_BINDING capabilities, it must be bound in the same tick when it is created. Alternatively, use .withLateBinding() modifier", (Object[])new Object[]{producer});
                DataStreams.bind(producer, binder.getInput());
                producer.getResult().whenComplete((arg_0, arg_1) -> ((SettableStage)result).set(arg_0, arg_1));
            } else {
                DataStreams.bind(StreamProducer.closingWithError(throwable), binder.getInput());
                result.setException(throwable);
            }
        });
        return binder.getOutput().withResult(result);
    }

    default public <U> StreamProducerWithResult<T, U> thenApply(Function<? super X, ? extends U> fn) {
        return this.withResult(this.getResult().thenApply(fn));
    }

    default public <U> StreamProducerWithResult<T, U> thenApplyEx(BiFunction<? super X, Throwable, ? extends U> fn) {
        return this.withResult(this.getResult().thenApplyEx(fn));
    }

    default public StreamProducerWithResult<T, X> thenRun(Runnable action) {
        this.getResult().post().thenRun(action);
        return this;
    }

    default public StreamProducerWithResult<T, X> thenRunEx(Runnable action) {
        this.getResult().post().thenRunEx(action);
        return this;
    }

    default public <U> StreamProducerWithResult<T, U> thenCompose(Function<? super X, ? extends Stage<U>> fn) {
        return this.withResult(this.getResult().post().thenCompose(fn));
    }

    default public <U> StreamProducerWithResult<T, U> thenComposeEx(BiFunction<? super X, Throwable, ? extends Stage<U>> fn) {
        return this.withResult(this.getResult().post().thenComposeEx(fn));
    }

    default public StreamProducerWithResult<T, X> whenComplete(StageConsumer<? super X> consumer) {
        this.getResult().post().whenComplete(consumer);
        return this;
    }

    default public StreamProducerWithResult<T, X> whenResult(Consumer<? super X> action) {
        this.getResult().post().whenResult(action);
        return this;
    }

    default public StreamProducerWithResult<T, X> whenException(Consumer<Throwable> consumer) {
        this.getResult().post().whenException(consumer);
        return this;
    }
}

