/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.stream.file;

import io.datakernel.bytebuf.ByteBuf;
import io.datakernel.bytebuf.ByteBufPool;
import io.datakernel.file.AsyncFile;
import io.datakernel.stream.AbstractStreamProducer;
import io.datakernel.stream.StreamDataReceiver;
import io.datakernel.util.MemSize;
import io.datakernel.util.Preconditions;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StreamFileReader
extends AbstractStreamProducer<ByteBuf> {
    private static final Logger logger = LoggerFactory.getLogger(StreamFileReader.class);
    public static final OpenOption[] READ_OPTIONS = new OpenOption[]{StandardOpenOption.READ};
    public static final MemSize DEFAULT_BUFFER_SIZE = MemSize.kilobytes((long)8L);
    private final AsyncFile asyncFile;
    private boolean reading = false;
    private int bufferSize = DEFAULT_BUFFER_SIZE.toInt();
    private long position = 0L;
    private long length = Long.MAX_VALUE;

    private StreamFileReader(AsyncFile asyncFile) {
        this.asyncFile = asyncFile;
    }

    public static StreamFileReader readFile(ExecutorService executor, Path path) throws IOException {
        return new StreamFileReader(AsyncFile.open((ExecutorService)executor, (Path)path, (OpenOption[])READ_OPTIONS));
    }

    public static StreamFileReader readFile(AsyncFile asyncFile) {
        return new StreamFileReader(asyncFile);
    }

    public StreamFileReader withBufferSize(MemSize bufferSize) {
        Preconditions.checkArgument((bufferSize.toInt() > 0 ? 1 : 0) != 0, (Object)"Buffer size cannot be less than or equal to zero");
        this.bufferSize = bufferSize.toInt();
        return this;
    }

    public StreamFileReader withStartingPosition(long position) {
        Preconditions.checkState((this.getConsumer() == null ? 1 : 0) != 0, (Object)"Cannot set position after binding the reader");
        Preconditions.checkArgument((position >= 0L ? 1 : 0) != 0, (Object)"Position cannot be less than zero");
        this.position = position;
        return this;
    }

    public StreamFileReader withReadingLength(long length) {
        Preconditions.checkState((this.getConsumer() == null ? 1 : 0) != 0, (Object)"Cannot set reading length after binding the reader");
        Preconditions.checkArgument((length >= -1L ? 1 : 0) != 0, (Object)"Reading length cannot be less than -1");
        this.length = length == -1L ? Long.MAX_VALUE : length;
        return this;
    }

    public long getPosition() {
        return this.position;
    }

    private void process() {
        if (!this.isReceiverReady()) {
            this.reading = false;
            return;
        }
        ByteBuf buf = ByteBufPool.allocate((int)((int)Math.min((long)this.bufferSize, this.length)));
        this.asyncFile.read(buf, this.position).whenComplete((bytesRead, e) -> {
            if (e != null) {
                buf.recycle();
                this.closeWithError(e);
            } else if (bytesRead == -1) {
                buf.recycle();
                this.sendEndOfStream();
            } else {
                this.send(buf);
                this.position += (long)bytesRead.intValue();
                if (this.length != Long.MAX_VALUE) {
                    this.length -= (long)bytesRead.intValue();
                }
                if (this.length == 0L) {
                    this.sendEndOfStream();
                }
            }
            this.process();
        });
    }

    @Override
    protected void onProduce(StreamDataReceiver<ByteBuf> receiver) {
        if (!this.reading) {
            this.reading = true;
            this.process();
        }
    }

    @Override
    protected void cleanup() {
        this.asyncFile.close().whenComplete(($, e) -> {
            if (e == null) {
                logger.trace(this + ": closed file");
            } else {
                logger.error(this + ": failed to close file", e);
            }
        });
    }

    @Override
    protected void onError(Throwable t) {
    }

    @Override
    public String toString() {
        return "StreamFileReader{" + this.asyncFile + ", pos=" + this.position + (this.length == Long.MAX_VALUE ? "" : ", len=" + this.length) + (this.reading ? ", reading" : "") + '}';
    }
}

