/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.stream.net;

import com.google.gson.TypeAdapter;
import io.datakernel.bytebuf.ByteBuf;
import io.datakernel.bytebuf.ByteBufPool;
import io.datakernel.bytebuf.ByteBufStrings;
import io.datakernel.exception.ParseException;
import io.datakernel.stream.net.MessagingSerializer;
import io.datakernel.util.MemSize;
import io.datakernel.util.gson.GsonAdapters;
import java.io.IOException;

public final class MessagingSerializers {
    public static final ParseException DESERIALIZE_ERR = new ParseException("Can't deserialize message");

    private MessagingSerializers() {
    }

    public static <I, O> MessagingSerializer<I, O> ofJson(final TypeAdapter<I> in, final TypeAdapter<O> out) {
        return new MessagingSerializer<I, O>(){

            @Override
            public I tryDeserialize(ByteBuf buf) throws ParseException {
                for (int len = 0; len < buf.readRemaining(); ++len) {
                    if (buf.peek(len) != 0) continue;
                    try {
                        Object item = GsonAdapters.fromJson((TypeAdapter)in, (String)ByteBufStrings.decodeUtf8((byte[])buf.array(), (int)buf.readPosition(), (int)len));
                        buf.moveReadPosition(len + 1);
                        return item;
                    }
                    catch (IOException e) {
                        throw DESERIALIZE_ERR;
                    }
                }
                return null;
            }

            @Override
            public ByteBuf serialize(O item) {
                ByteBufPoolAppendable appendable = new ByteBufPoolAppendable();
                try {
                    GsonAdapters.toJson((TypeAdapter)out, item, (Appendable)appendable);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                appendable.append("\u0000");
                return appendable.get();
            }
        };
    }

    static class ByteBufPoolAppendable
    implements Appendable {
        static final MemSize INITIAL_BUF_SIZE = MemSize.kilobytes((long)2L);
        ByteBuf container;

        ByteBufPoolAppendable() {
            this(INITIAL_BUF_SIZE);
        }

        ByteBufPoolAppendable(MemSize size) {
            this.container = ByteBufPool.allocate((MemSize)size);
        }

        ByteBufPoolAppendable(int size) {
            this.container = ByteBufPool.allocate((int)size);
        }

        @Override
        public Appendable append(CharSequence csq) {
            this.container = ByteBufPool.ensureWriteRemaining((ByteBuf)this.container, (int)(csq.length() * 3));
            for (int i = 0; i < csq.length(); ++i) {
                ByteBufStrings.putUtf8((ByteBuf)this.container, (char)csq.charAt(i));
            }
            return this;
        }

        @Override
        public Appendable append(CharSequence csq, int start, int end) {
            return this.append(csq.subSequence(start, end));
        }

        @Override
        public Appendable append(char c) {
            this.container = ByteBufPool.ensureWriteRemaining((ByteBuf)this.container, (int)3);
            ByteBufStrings.putUtf8((ByteBuf)this.container, (char)c);
            return this;
        }

        public ByteBuf get() {
            return this.container;
        }
    }
}

