/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.stream.processor;

import io.datakernel.stream.processor.BufferAppendableException;
import java.io.IOException;
import java.nio.charset.Charset;

public final class BufferAppendable
implements Appendable {
    private byte[] buf;
    private int pos;

    private BufferAppendable(byte[] buf, int position) {
        assert (position >= 0 && position <= buf.length);
        this.buf = buf;
        this.pos = position;
    }

    public static BufferAppendable create(byte[] buf, int position) {
        return new BufferAppendable(buf, position);
    }

    protected void ensureSize(int size) {
    }

    public byte[] array() {
        return this.buf;
    }

    public void array(byte[] buf) {
        this.buf = buf;
    }

    public void set(byte[] buf, int position) {
        assert (position >= 0 && position <= buf.length);
        this.buf = buf;
        this.pos = position;
    }

    public int position() {
        return this.pos;
    }

    public void position(int position) {
        assert (position >= 0 && position <= this.buf.length);
        this.pos = position;
    }

    public int remaining() {
        return this.buf.length - this.pos;
    }

    private void writeUtfChar(char c) {
        if (c <= '\u07ff') {
            this.buf[this.pos] = (byte)(0xC0 | c >> 6 & 0x1F);
            this.buf[this.pos + 1] = (byte)(0x80 | c & 0x3F);
            this.pos += 2;
        } else {
            this.buf[this.pos] = (byte)(0xE0 | c >> 12 & 0xF);
            this.buf[this.pos + 1] = (byte)(0x80 | c >> 6 & 0x3F);
            this.buf[this.pos + 2] = (byte)(0x80 | c & 0x3F);
            this.pos += 3;
        }
    }

    @Override
    public Appendable append(CharSequence csq) throws IOException {
        return this.append(csq, 0, csq.length());
    }

    @Override
    public Appendable append(CharSequence csq, int start, int end) {
        this.ensureSize((end - start) * 3);
        try {
            for (int i = start; i < end; ++i) {
                char c = csq.charAt(i);
                if (c <= '\u007f') {
                    this.buf[this.pos++] = (byte)c;
                    continue;
                }
                this.writeUtfChar(c);
            }
            return this;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new BufferAppendableException();
        }
    }

    @Override
    public Appendable append(char c) {
        this.ensureSize(3);
        try {
            if (c <= '\u007f') {
                this.buf[this.pos++] = (byte)c;
            } else {
                this.writeUtfChar(c);
            }
            return this;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new BufferAppendableException();
        }
    }

    public String toString() {
        return new String(this.buf, 0, this.pos, Charset.forName("UTF-8"));
    }
}

