/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.stream.processor;

import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;

public final class BufferReader
extends Reader {
    private byte[] buf;
    private int pos;
    private int limit;

    private BufferReader(byte[] array, int position, int length) {
        this.set(array, position, length);
    }

    public static BufferReader create(byte[] array, int position, int length) {
        return new BufferReader(array, position, length);
    }

    @Override
    public void close() throws IOException {
    }

    public void set(byte[] array, int position, int len) {
        assert (position >= 0 && len >= 0);
        this.buf = array;
        this.pos = position;
        this.limit = position + len;
    }

    public byte[] array() {
        return this.buf;
    }

    public int position() {
        return this.pos;
    }

    public void position(int position) {
        assert (this.pos >= 0);
        this.pos = position;
    }

    private int remaining() {
        return this.buf.length - this.pos;
    }

    @Override
    public int read() throws IOException {
        if (this.pos >= this.limit) {
            return -1;
        }
        try {
            int c = this.buf[this.pos] & 0xFF;
            if (c < 128) {
                ++this.pos;
            } else if (c < 224) {
                c = (char)((c & 0x1F) << 6 | this.buf[this.pos + 1] & 0x3F);
                this.pos += 2;
            } else {
                c = (char)((c & 0xF) << 12 | (this.buf[this.pos + 1] & 0x3F) << 6 | this.buf[this.pos + 2] & 0x3F);
                this.pos += 3;
            }
            if (this.pos > this.limit) {
                throw new IOException();
            }
            return c;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.pos > this.limit) {
            return -1;
        }
        try {
            int i;
            int to = off + len;
            for (i = off; i < to && this.pos < this.limit; ++i) {
                int c = this.buf[this.pos] & 0xFF;
                if (c < 128) {
                    cbuf[i] = (char)c;
                    ++this.pos;
                    continue;
                }
                if (c < 224) {
                    cbuf[i] = (char)((c & 0x1F) << 6 | this.buf[this.pos + 1] & 0x3F);
                    this.pos += 2;
                    continue;
                }
                cbuf[i] = (char)((c & 0xF) << 12 | (this.buf[this.pos + 1] & 0x3F) << 6 | this.buf[this.pos + 2] & 0x3F);
                this.pos += 3;
            }
            if (this.pos > this.limit) {
                throw new IOException();
            }
            if (this.pos == this.limit) {
                this.pos = Integer.MAX_VALUE;
            }
            return i - off;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IOException(e);
        }
    }

    public String toString() {
        return new String(this.buf, this.pos, this.limit - this.pos, Charset.forName("UTF-8"));
    }
}

