/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.stream.processor;

import io.datakernel.stream.processor.Sharder;

public final class Sharders {
    private Sharders() {
    }

    public static final class HashSharder<K>
    implements Sharder<K> {
        private int partitions;

        public HashSharder() {
        }

        public HashSharder(int partitions) {
            assert (partitions >= 0);
            this.partitions = partitions;
        }

        @Override
        public int shard(K object) {
            int hash = object.hashCode();
            int hashAbs = hash < 0 ? (hash == Integer.MIN_VALUE ? Integer.MAX_VALUE : -hash) : hash;
            return hashAbs % this.partitions;
        }

        public int getPartitions() {
            return this.partitions;
        }

        public void setPartitions(int partitions) {
            this.partitions = partitions;
        }
    }
}

