/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.stream.processor;

import io.datakernel.stream.AbstractStreamConsumer;
import io.datakernel.stream.AbstractStreamProducer;
import io.datakernel.stream.StreamConsumer;
import io.datakernel.stream.StreamDataReceiver;
import io.datakernel.stream.StreamProducer;
import io.datakernel.stream.processor.StreamTransformer;
import java.util.function.Function;

public final class StreamFunction<I, O>
implements StreamTransformer<I, O> {
    private final Function<I, O> function;
    private final Input input;
    private final Output output;

    private StreamFunction(Function<I, O> function) {
        this.function = function;
        this.input = new Input();
        this.output = new Output();
    }

    public static <I, O> StreamFunction<I, O> create(Function<I, O> function) {
        return new StreamFunction<I, O>(function);
    }

    @Override
    public StreamConsumer<I> getInput() {
        return this.input;
    }

    @Override
    public StreamProducer<O> getOutput() {
        return this.output;
    }

    protected final class Output
    extends AbstractStreamProducer<O> {
        protected Output() {
        }

        @Override
        protected void onSuspended() {
            StreamFunction.this.input.getProducer().suspend();
        }

        @Override
        protected void onError(Throwable t) {
            StreamFunction.this.input.closeWithError(t);
        }

        @Override
        protected void onProduce(StreamDataReceiver<O> dataReceiver) {
            StreamFunction.this.input.getProducer().produce(StreamFunction.this.function == Function.identity() ? dataReceiver : item -> dataReceiver.onData(StreamFunction.this.function.apply(item)));
        }
    }

    protected final class Input
    extends AbstractStreamConsumer<I> {
        protected Input() {
        }

        @Override
        protected void onEndOfStream() {
            StreamFunction.this.output.sendEndOfStream();
        }

        @Override
        protected void onError(Throwable t) {
            StreamFunction.this.output.closeWithError(t);
        }
    }
}

