/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.stream.processor;

import io.datakernel.bytebuf.ByteBuf;
import io.datakernel.bytebuf.ByteBufPool;
import io.datakernel.jmx.ValueStats;
import io.datakernel.stream.AbstractStreamConsumer;
import io.datakernel.stream.AbstractStreamProducer;
import io.datakernel.stream.AbstractStreamTransformer_1_1;
import io.datakernel.stream.StreamConsumer;
import io.datakernel.stream.StreamDataReceiver;
import io.datakernel.stream.StreamProducer;
import io.datakernel.stream.StreamStatus;
import io.datakernel.stream.processor.StreamTransformer;
import java.time.Duration;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.xxhash.StreamingXXHash32;
import net.jpountz.xxhash.XXHashFactory;

public final class StreamLZ4Compressor
implements StreamTransformer<ByteBuf, ByteBuf> {
    static final byte[] MAGIC = new byte[]{76, 90, 52, 66, 108, 111, 99, 107};
    static final int MAGIC_LENGTH = MAGIC.length;
    public static final int HEADER_LENGTH = MAGIC_LENGTH + 1 + 4 + 4 + 4;
    static final int COMPRESSION_LEVEL_BASE = 10;
    static final int COMPRESSION_METHOD_RAW = 16;
    static final int COMPRESSION_METHOD_LZ4 = 32;
    static final int DEFAULT_SEED = -1756908916;
    private static final int MIN_BLOCK_SIZE = 64;
    private final LZ4Compressor compressor;
    private Input input;
    private Output output;

    private StreamLZ4Compressor(LZ4Compressor compressor) {
        this.compressor = compressor;
        this.rebuild();
    }

    protected void rebuild() {
        this.input = new Input();
        this.output = new Output(this.compressor);
    }

    public static StreamLZ4Compressor rawCompressor() {
        return new StreamLZ4Compressor(null);
    }

    public static StreamLZ4Compressor fastCompressor() {
        return new StreamLZ4Compressor(LZ4Factory.fastestInstance().fastCompressor());
    }

    public static StreamLZ4Compressor highCompressor() {
        return new StreamLZ4Compressor(LZ4Factory.fastestInstance().highCompressor());
    }

    public static StreamLZ4Compressor highCompressor(int compressionLevel) {
        return new StreamLZ4Compressor(LZ4Factory.fastestInstance().highCompressor(compressionLevel));
    }

    public static StreamLZ4Compressor create(int compressionLevel) {
        return compressionLevel == 0 ? StreamLZ4Compressor.fastCompressor() : StreamLZ4Compressor.highCompressor(compressionLevel);
    }

    @Override
    public StreamConsumer<ByteBuf> getInput() {
        return this.input;
    }

    @Override
    public StreamProducer<ByteBuf> getOutput() {
        return this.output;
    }

    private static int compressionLevel(int blockSize) {
        int compressionLevel = 32 - Integer.numberOfLeadingZeros(blockSize - 1);
        assert (1 << compressionLevel >= blockSize);
        assert (blockSize * 2 > 1 << compressionLevel);
        compressionLevel = Math.max(0, compressionLevel - 10);
        assert (compressionLevel >= 0 && compressionLevel <= 15);
        return compressionLevel;
    }

    private static void writeIntLE(int i, byte[] buf, int off) {
        buf[off++] = (byte)i;
        buf[off++] = (byte)(i >>> 8);
        buf[off++] = (byte)(i >>> 16);
        buf[off] = (byte)(i >>> 24);
    }

    private static ByteBuf compressBlock(LZ4Compressor compressor, StreamingXXHash32 checksum, byte[] bytes, int off, int len) {
        int compressMethod;
        assert (len != 0);
        int compressionLevel = StreamLZ4Compressor.compressionLevel(len < 64 ? 64 : len);
        int outputBufMaxSize = HEADER_LENGTH + (compressor == null ? len : compressor.maxCompressedLength(len));
        ByteBuf outputBuf = ByteBufPool.allocate((int)outputBufMaxSize);
        outputBuf.put(MAGIC);
        byte[] outputBytes = outputBuf.array();
        checksum.reset();
        checksum.update(bytes, off, len);
        int check = checksum.getValue();
        int compressedLength = len;
        if (compressor != null) {
            compressedLength = compressor.compress(bytes, off, len, outputBytes, HEADER_LENGTH);
        }
        if (compressor == null || compressedLength >= len) {
            compressMethod = 16;
            compressedLength = len;
            System.arraycopy(bytes, off, outputBytes, HEADER_LENGTH, len);
        } else {
            compressMethod = 32;
        }
        outputBytes[StreamLZ4Compressor.MAGIC_LENGTH] = (byte)(compressMethod | compressionLevel);
        StreamLZ4Compressor.writeIntLE(compressedLength, outputBytes, MAGIC_LENGTH + 1);
        StreamLZ4Compressor.writeIntLE(len, outputBytes, MAGIC_LENGTH + 5);
        StreamLZ4Compressor.writeIntLE(check, outputBytes, MAGIC_LENGTH + 9);
        assert (MAGIC_LENGTH + 13 == HEADER_LENGTH);
        outputBuf.writePosition(HEADER_LENGTH + compressedLength);
        return outputBuf;
    }

    private static ByteBuf createEndOfStreamBlock() {
        int compressionLevel = StreamLZ4Compressor.compressionLevel(64);
        ByteBuf outputBuf = ByteBufPool.allocate((int)HEADER_LENGTH);
        byte[] outputBytes = outputBuf.array();
        System.arraycopy(MAGIC, 0, outputBytes, 0, MAGIC_LENGTH);
        outputBytes[StreamLZ4Compressor.MAGIC_LENGTH] = (byte)(0x10 | compressionLevel);
        StreamLZ4Compressor.writeIntLE(0, outputBytes, MAGIC_LENGTH + 1);
        StreamLZ4Compressor.writeIntLE(0, outputBytes, MAGIC_LENGTH + 5);
        StreamLZ4Compressor.writeIntLE(0, outputBytes, MAGIC_LENGTH + 9);
        outputBuf.writePosition(HEADER_LENGTH);
        return outputBuf;
    }

    private final class Output
    extends AbstractStreamProducer<ByteBuf>
    implements StreamDataReceiver<ByteBuf> {
        private final LZ4Compressor compressor;
        private final StreamingXXHash32 checksum = XXHashFactory.fastestInstance().newStreamingHash32(-1756908916);

        private Output(LZ4Compressor compressor) {
            this.compressor = compressor;
        }

        @Override
        protected void onSuspended() {
            StreamLZ4Compressor.this.input.getProducer().suspend();
        }

        @Override
        protected void produce() {
            if (StreamLZ4Compressor.this.input.getStatus() != StreamStatus.END_OF_STREAM) {
                StreamLZ4Compressor.this.input.getProducer().produce(this);
            } else {
                this.flushAndClose();
            }
        }

        private void flushAndClose() {
            if (this.isReceiverReady()) {
                this.send(StreamLZ4Compressor.createEndOfStreamBlock());
                this.sendEndOfStream();
            }
        }

        @Override
        protected void onError(Throwable t) {
            StreamLZ4Compressor.this.input.closeWithError(t);
        }

        @Override
        public void onData(ByteBuf buf) {
            if (buf.canRead()) {
                ByteBuf outputBuf = StreamLZ4Compressor.compressBlock(this.compressor, this.checksum, buf.array(), buf.readPosition(), buf.readRemaining());
                this.send(outputBuf);
            }
            buf.recycle();
        }
    }

    private final class Input
    extends AbstractStreamConsumer<ByteBuf> {
        private Input() {
        }

        @Override
        protected void onEndOfStream() {
            StreamLZ4Compressor.this.output.flushAndClose();
        }

        @Override
        protected void onError(Throwable t) {
            StreamLZ4Compressor.this.output.closeWithError(t);
        }
    }

    public static class JmxInspector
    extends AbstractStreamTransformer_1_1.JmxInspector
    implements Inspector {
        public static final Duration SMOOTHING_WINDOW = Duration.ofMinutes(1L);
        private final ValueStats bytesIn = ValueStats.create((Duration)SMOOTHING_WINDOW);
        private final ValueStats bytesOut = ValueStats.create((Duration)SMOOTHING_WINDOW);

        @Override
        public void onBuf(ByteBuf in, ByteBuf out) {
            this.bytesIn.recordValue(in.readRemaining());
            this.bytesOut.recordValue(out.readRemaining());
        }
    }

    public static interface Inspector
    extends AbstractStreamTransformer_1_1.Inspector {
        public void onBuf(ByteBuf var1, ByteBuf var2);
    }
}

