/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.stream.processor;

import io.datakernel.bytebuf.ByteBuf;
import io.datakernel.bytebuf.ByteBufPool;
import io.datakernel.bytebuf.ByteBufQueue;
import io.datakernel.exception.ParseException;
import io.datakernel.exception.TruncatedDataException;
import io.datakernel.stream.AbstractStreamConsumer;
import io.datakernel.stream.AbstractStreamProducer;
import io.datakernel.stream.StreamConsumer;
import io.datakernel.stream.StreamDataReceiver;
import io.datakernel.stream.StreamProducer;
import io.datakernel.stream.StreamStatus;
import io.datakernel.stream.processor.StreamLZ4Compressor;
import io.datakernel.stream.processor.StreamTransformer;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import net.jpountz.util.SafeUtils;
import net.jpountz.xxhash.StreamingXXHash32;
import net.jpountz.xxhash.XXHashFactory;

public final class StreamLZ4Decompressor
implements StreamTransformer<ByteBuf, ByteBuf> {
    public static final int HEADER_LENGTH = StreamLZ4Compressor.HEADER_LENGTH;
    private final LZ4FastDecompressor decompressor;
    private final StreamingXXHash32 checksum;
    private Input input;
    private Output output;
    private Inspector inspector;

    private StreamLZ4Decompressor(LZ4FastDecompressor decompressor, StreamingXXHash32 checksum) {
        this.decompressor = decompressor;
        this.checksum = checksum;
        this.recreate();
    }

    private void recreate() {
        this.output = new Output(this.decompressor, this.checksum);
        this.input = new Input();
    }

    @Override
    public StreamConsumer<ByteBuf> getInput() {
        return this.input;
    }

    @Override
    public StreamProducer<ByteBuf> getOutput() {
        return this.output;
    }

    public static StreamLZ4Decompressor create(LZ4FastDecompressor decompressor, StreamingXXHash32 checksum) {
        return new StreamLZ4Decompressor(decompressor, checksum);
    }

    public static StreamLZ4Decompressor create() {
        return new StreamLZ4Decompressor(LZ4Factory.fastestInstance().fastDecompressor(), XXHashFactory.fastestInstance().newStreamingHash32(-1756908916));
    }

    public StreamLZ4Decompressor withInspector(Inspector inspector) {
        this.inspector = inspector;
        this.recreate();
        return this;
    }

    private static ByteBuf readBody(LZ4FastDecompressor decompressor, StreamingXXHash32 checksum, Header header, byte[] bytes, int off) throws ParseException {
        ByteBuf outputBuf = ByteBufPool.allocate((int)header.originalLen);
        outputBuf.writePosition(header.originalLen);
        switch (header.compressionMethod) {
            case 16: {
                System.arraycopy(bytes, off, outputBuf.array(), 0, header.originalLen);
                break;
            }
            case 32: {
                try {
                    int compressedLen2 = decompressor.decompress(bytes, off, outputBuf.array(), 0, header.originalLen);
                    if (header.compressedLen != compressedLen2) {
                        throw new ParseException("Stream is corrupted");
                    }
                    break;
                }
                catch (LZ4Exception e) {
                    throw new ParseException("Stream is corrupted", (Throwable)e);
                }
            }
            default: {
                throw new AssertionError();
            }
        }
        checksum.reset();
        checksum.update(outputBuf.array(), 0, header.originalLen);
        if (checksum.getValue() != header.check) {
            throw new ParseException("Stream is corrupted");
        }
        return outputBuf;
    }

    private static void readHeader(Header header, byte[] buf, int off) throws ParseException {
        for (int i = 0; i < StreamLZ4Compressor.MAGIC_LENGTH; ++i) {
            if (buf[off + i] == StreamLZ4Compressor.MAGIC[i]) continue;
            throw new ParseException("Stream is corrupted");
        }
        int token = buf[off + StreamLZ4Compressor.MAGIC_LENGTH] & 0xFF;
        header.compressionMethod = token & 0xF0;
        int compressionLevel = 10 + (token & 0xF);
        if (header.compressionMethod != 16 && header.compressionMethod != 32) {
            throw new ParseException("Stream is corrupted");
        }
        header.compressedLen = SafeUtils.readIntLE((byte[])buf, (int)(off + StreamLZ4Compressor.MAGIC_LENGTH + 1));
        header.originalLen = SafeUtils.readIntLE((byte[])buf, (int)(off + StreamLZ4Compressor.MAGIC_LENGTH + 5));
        header.check = SafeUtils.readIntLE((byte[])buf, (int)(off + StreamLZ4Compressor.MAGIC_LENGTH + 9));
        if (header.originalLen > 1 << compressionLevel || header.originalLen < 0 || header.compressedLen < 0 || header.originalLen == 0 && header.compressedLen != 0 || header.originalLen != 0 && header.compressedLen == 0 || header.compressionMethod == 16 && header.originalLen != header.compressedLen) {
            throw new ParseException("Stream is corrupted");
        }
        if (header.originalLen == 0) {
            if (header.check != 0) {
                throw new ParseException("Stream is corrupted");
            }
            header.finished = true;
        }
    }

    static /* synthetic */ Inspector access$300(StreamLZ4Decompressor x0) {
        return x0.inspector;
    }

    public static final class Header {
        public int originalLen;
        public int compressedLen;
        public int compressionMethod;
        public int check;
        public boolean finished;
    }

    private final class Output
    extends AbstractStreamProducer<ByteBuf>
    implements StreamDataReceiver<ByteBuf> {
        private final LZ4FastDecompressor decompressor;
        private final StreamingXXHash32 checksum;
        private final ByteBufQueue queue = ByteBufQueue.create();
        private final ByteBuf headerBuf = ByteBuf.wrapForWriting((byte[])new byte[HEADER_LENGTH]);
        private final Header header = new Header();
        private final Inspector inspector = StreamLZ4Decompressor.access$300(StreamLZ4Decompressor.this);

        private Output(LZ4FastDecompressor decompressor, StreamingXXHash32 checksum) {
            this.decompressor = decompressor;
            this.checksum = checksum;
        }

        @Override
        protected void onSuspended() {
            StreamLZ4Decompressor.this.input.getProducer().suspend();
        }

        @Override
        protected void onError(Throwable t) {
            StreamLZ4Decompressor.this.input.closeWithError(t);
        }

        @Override
        public void onData(ByteBuf buf) {
            if (this.inspector != null) {
                this.inspector.onInputBuf(StreamLZ4Decompressor.this, buf);
            }
            try {
                if (this.header.finished) {
                    throw new ParseException(String.format("Unexpected byteBuf after LZ4 EOS packet %s : %s", this, buf));
                }
                this.queue.add(buf);
                StreamLZ4Decompressor.this.output.produce();
            }
            catch (ParseException e) {
                StreamLZ4Decompressor.this.input.closeWithError(e);
            }
        }

        @Override
        protected void produce() {
            block8: {
                try {
                    while (this.isReceiverReady() && this.queue.hasRemainingBytes(this.headerBuf.writeRemaining())) {
                        if (this.headerBuf.canWrite()) {
                            this.queue.drainTo(this.headerBuf);
                            StreamLZ4Decompressor.readHeader(this.header, this.headerBuf.array(), this.headerBuf.readPosition());
                        }
                        if (this.header.finished) {
                            if (!this.queue.isEmpty()) {
                                throw new ParseException(String.format("Unexpected byteBuf after LZ4 EOS packet %s : %s", this, this.queue));
                            }
                            if (this.inspector == null) break;
                            this.inspector.onBlock(StreamLZ4Decompressor.this, this.header, ByteBuf.empty(), ByteBuf.empty());
                            break;
                        }
                        if (!this.queue.hasRemainingBytes(this.header.compressedLen)) break;
                        ByteBuf inputBuf = this.queue.takeExactSize(this.header.compressedLen);
                        ByteBuf outputBuf = StreamLZ4Decompressor.readBody(this.decompressor, this.checksum, this.header, inputBuf.array(), inputBuf.readPosition());
                        if (this.inspector != null) {
                            this.inspector.onBlock(StreamLZ4Decompressor.this, this.header, inputBuf, outputBuf);
                        }
                        inputBuf.recycle();
                        this.send(outputBuf);
                        this.headerBuf.rewind();
                    }
                    if (!this.isReceiverReady()) break block8;
                    StreamLZ4Decompressor.this.input.getProducer().produce(this);
                    if (StreamLZ4Decompressor.this.input.getStatus() != StreamStatus.END_OF_STREAM) break block8;
                    if (this.queue.isEmpty()) {
                        StreamLZ4Decompressor.this.output.sendEndOfStream();
                        break block8;
                    }
                    throw new TruncatedDataException(String.format("Truncated LZ4 data stream, %s : %s", this, this.queue));
                }
                catch (ParseException e) {
                    this.closeWithError(e);
                }
            }
        }

        @Override
        protected void cleanup() {
            this.queue.clear();
        }
    }

    private final class Input
    extends AbstractStreamConsumer<ByteBuf> {
        private Input() {
        }

        @Override
        protected void onEndOfStream() {
            StreamLZ4Decompressor.this.output.produce();
        }

        @Override
        protected void onError(Throwable t) {
            StreamLZ4Decompressor.this.output.closeWithError(t);
        }
    }

    public static interface Inspector {
        public void onInputBuf(StreamLZ4Decompressor var1, ByteBuf var2);

        public void onBlock(StreamLZ4Decompressor var1, Header var2, ByteBuf var3, ByteBuf var4);
    }
}

