/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.stream.processor;

import io.datakernel.stream.AbstractStreamConsumer;
import io.datakernel.stream.AbstractStreamProducer;
import io.datakernel.stream.StreamCapability;
import io.datakernel.stream.StreamConsumer;
import io.datakernel.stream.StreamDataReceiver;
import io.datakernel.stream.StreamProducer;
import io.datakernel.stream.processor.StreamTransformer;
import java.util.Set;

public final class StreamLateBinder<T>
implements StreamTransformer<T, T> {
    private final AbstractStreamConsumer<T> input = new Input();
    private final AbstractStreamProducer<T> output = new Output();
    private StreamDataReceiver<T> waitingReceiver;

    private StreamLateBinder() {
    }

    public static <T> StreamLateBinder<T> create() {
        return new StreamLateBinder<T>();
    }

    @Override
    public StreamConsumer<T> getInput() {
        return this.input;
    }

    @Override
    public StreamProducer<T> getOutput() {
        return this.output;
    }

    private class Output
    extends AbstractStreamProducer<T> {
        private Output() {
        }

        @Override
        protected void onProduce(StreamDataReceiver<T> dataReceiver) {
            StreamProducer producer = StreamLateBinder.this.input.getProducer();
            if (producer == null) {
                StreamLateBinder.this.waitingReceiver = dataReceiver;
                return;
            }
            producer.produce(dataReceiver);
        }

        @Override
        protected void onSuspended() {
            StreamProducer producer = StreamLateBinder.this.input.getProducer();
            if (producer == null) {
                StreamLateBinder.this.waitingReceiver = null;
                return;
            }
            producer.suspend();
        }

        @Override
        protected void onError(Throwable t) {
            StreamLateBinder.this.input.closeWithError(t);
        }

        @Override
        public Set<StreamCapability> getCapabilities() {
            return Output.addCapabilities(StreamLateBinder.this.input.getProducer(), StreamCapability.LATE_BINDING, new StreamCapability[0]);
        }
    }

    private class Input
    extends AbstractStreamConsumer<T> {
        private Input() {
        }

        @Override
        protected void onStarted() {
            if (StreamLateBinder.this.waitingReceiver != null) {
                this.getProducer().produce(StreamLateBinder.this.waitingReceiver);
                StreamLateBinder.this.waitingReceiver = null;
            }
        }

        @Override
        protected void onEndOfStream() {
            StreamLateBinder.this.output.sendEndOfStream();
        }

        @Override
        protected void onError(Throwable t) {
            StreamLateBinder.this.output.closeWithError(t);
        }

        @Override
        public Set<StreamCapability> getCapabilities() {
            return Input.addCapabilities(StreamLateBinder.this.output.getConsumer(), StreamCapability.LATE_BINDING, new StreamCapability[0]);
        }
    }
}

