/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.stream.processor;

import io.datakernel.stream.AbstractStreamConsumer;
import io.datakernel.stream.AbstractStreamProducer;
import io.datakernel.stream.StreamConsumer;
import io.datakernel.stream.StreamDataReceiver;
import io.datakernel.stream.StreamProducer;
import io.datakernel.stream.processor.StreamTransformer;

public final class StreamMap<I, O>
implements StreamTransformer<I, O> {
    private final Input input;
    private final Output output;
    private final Mapper<I, O> mapper;

    private StreamMap(Mapper<I, O> mapper) {
        this.mapper = mapper;
        this.input = new Input();
        this.output = new Output();
    }

    public static <I, O> StreamMap<I, O> create(Mapper<I, O> mapper) {
        return new StreamMap<I, O>(mapper);
    }

    @Override
    public StreamConsumer<I> getInput() {
        return this.input;
    }

    @Override
    public StreamProducer<O> getOutput() {
        return this.output;
    }

    public static <I, T, O> Mapper<I, O> combine(Mapper<I, T> mapper1, Mapper<T, O> mapper2) {
        return (input, output) -> mapper1.map(input, item -> mapper2.map(item, output));
    }

    protected final class Output
    extends AbstractStreamProducer<O> {
        protected Output() {
        }

        @Override
        protected void onSuspended() {
            StreamMap.this.input.getProducer().suspend();
        }

        @Override
        protected void onError(Throwable t) {
            StreamMap.this.input.closeWithError(t);
        }

        @Override
        protected void onProduce(StreamDataReceiver<O> dataReceiver) {
            StreamMap.this.input.getProducer().produce(item -> StreamMap.this.mapper.map(item, dataReceiver));
        }
    }

    protected final class Input
    extends AbstractStreamConsumer<I> {
        protected Input() {
        }

        @Override
        protected void onEndOfStream() {
            StreamMap.this.output.sendEndOfStream();
        }

        @Override
        protected void onError(Throwable t) {
            StreamMap.this.output.closeWithError(t);
        }
    }

    public static abstract class MapperFilter<I>
    implements Mapper<I, I> {
        protected abstract boolean apply(I var1);

        @Override
        public final void map(I input, StreamDataReceiver<I> output) {
            if (this.apply(input)) {
                output.onData(input);
            }
        }
    }

    public static abstract class MapperProjection<I, O>
    implements Mapper<I, O> {
        protected abstract O apply(I var1);

        @Override
        public final void map(I input, StreamDataReceiver<O> output) {
            O result = this.apply(input);
            output.onData(result);
        }
    }

    public static interface Mapper<I, O> {
        public void map(I var1, StreamDataReceiver<O> var2);
    }
}

