/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.stream.processor;

import io.datakernel.stream.StreamConsumer;
import io.datakernel.stream.processor.AbstractStreamReducer;
import io.datakernel.stream.processor.StreamReducers;
import io.datakernel.util.Preconditions;
import java.util.Comparator;
import java.util.function.Function;

public final class StreamMerger<K, T>
extends AbstractStreamReducer<K, T, Void> {
    private final Function<T, K> keyFunction;
    private final StreamReducers.Reducer<K, T, T, Void> reducer;

    private StreamMerger(Function<T, K> keyFunction, Comparator<K> keyComparator, boolean deduplicate) {
        super(keyComparator);
        this.keyFunction = (Function)Preconditions.checkNotNull(keyFunction);
        this.reducer = deduplicate ? StreamReducers.mergeDeduplicateReducer() : StreamReducers.mergeSortReducer();
    }

    public static <K, T> StreamMerger<K, T> create(Function<T, K> keyFunction, Comparator<K> keyComparator, boolean deduplicate) {
        return new StreamMerger<K, T>(keyFunction, keyComparator, deduplicate);
    }

    public StreamMerger<K, T> withBufferSize(int bufferSize) {
        return (StreamMerger)super.withBufferSize(bufferSize);
    }

    public StreamConsumer<T> newInput() {
        return super.newInput(this.keyFunction, this.reducer);
    }
}

