/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.stream.processor;

import io.datakernel.stream.StreamDataReceiver;

public final class StreamReducers {
    private StreamReducers() {
    }

    public static <K, T> Reducer<K, T, T, Void> mergeDeduplicateReducer() {
        return new MergeDeduplicateReducer();
    }

    public static <K, T> Reducer<K, T, T, Void> mergeSortReducer() {
        return new MergeSortReducer();
    }

    public static class MergeSortReducer<K, T>
    implements Reducer<K, T, T, Void> {
        @Override
        public Void onFirstItem(StreamDataReceiver<T> stream, K key, T firstValue) {
            stream.onData(firstValue);
            return null;
        }

        @Override
        public Void onNextItem(StreamDataReceiver<T> stream, K key, T nextValue, Void accumulator) {
            stream.onData(nextValue);
            return null;
        }

        @Override
        public void onComplete(StreamDataReceiver<T> stream, K key, Void accumulator) {
        }
    }

    public static class MergeDeduplicateReducer<K, T>
    implements Reducer<K, T, T, Void> {
        @Override
        public Void onFirstItem(StreamDataReceiver<T> stream, K key, T firstValue) {
            stream.onData(firstValue);
            return null;
        }

        @Override
        public Void onNextItem(StreamDataReceiver<T> stream, K key, T nextValue, Void accumulator) {
            return null;
        }

        @Override
        public void onComplete(StreamDataReceiver<T> stream, K key, Void accumulator) {
        }
    }

    public static abstract class ReducerToAccumulator<K, I, A>
    extends ReducerToResult<K, I, A, A> {
        @Override
        public final A produceResult(A accumulator) {
            return accumulator;
        }
    }

    public static abstract class ReducerToResult<K, I, O, A> {
        public abstract A createAccumulator(K var1);

        public abstract A accumulate(A var1, I var2);

        public A combine(A accumulator, A anotherAccumulator) {
            throw new UnsupportedOperationException("can not combine two accumulators");
        }

        public abstract O produceResult(A var1);

        public final Reducer<K, I, O, A> inputToOutput() {
            return new InputToOutput(this);
        }

        public final Reducer<K, I, A, A> inputToAccumulator() {
            return new InputToAccumulator(this);
        }

        public final Reducer<K, A, O, A> accumulatorToOutput() {
            return new AccumulatorToOutput(this);
        }

        public final Reducer<K, A, A, A> accumulatorToAccumulator() {
            return new AccumulatorToAccumulator(this);
        }

        public static final class AccumulatorToAccumulator<K, I, O, A>
        implements Reducer<K, A, A, A> {
            private ReducerToResult<K, I, O, A> reducerToResult;

            public AccumulatorToAccumulator() {
            }

            public AccumulatorToAccumulator(ReducerToResult<K, I, O, A> reducerToResult) {
                this.reducerToResult = reducerToResult;
            }

            public ReducerToResult<K, I, O, A> getReducerToResult() {
                return this.reducerToResult;
            }

            public void setReducerToResult(ReducerToResult<K, I, O, A> reducerToResult) {
                this.reducerToResult = reducerToResult;
            }

            @Override
            public A onFirstItem(StreamDataReceiver<A> stream, K key, A firstValue) {
                return firstValue;
            }

            @Override
            public A onNextItem(StreamDataReceiver<A> stream, K key, A nextValue, A accumulator) {
                return this.reducerToResult.combine(accumulator, nextValue);
            }

            @Override
            public void onComplete(StreamDataReceiver<A> stream, K key, A accumulator) {
                stream.onData(accumulator);
            }
        }

        public static final class AccumulatorToOutput<K, I, O, A>
        implements Reducer<K, A, O, A> {
            private ReducerToResult<K, I, O, A> reducerToResult;

            public AccumulatorToOutput() {
            }

            public AccumulatorToOutput(ReducerToResult<K, I, O, A> reducerToResult) {
                this.reducerToResult = reducerToResult;
            }

            public ReducerToResult<K, I, O, A> getReducerToResult() {
                return this.reducerToResult;
            }

            public void setReducerToResult(ReducerToResult<K, I, O, A> reducerToResult) {
                this.reducerToResult = reducerToResult;
            }

            @Override
            public A onFirstItem(StreamDataReceiver<O> stream, K key, A firstValue) {
                return firstValue;
            }

            @Override
            public A onNextItem(StreamDataReceiver<O> stream, K key, A nextValue, A accumulator) {
                return this.reducerToResult.combine(accumulator, nextValue);
            }

            @Override
            public void onComplete(StreamDataReceiver<O> stream, K key, A accumulator) {
                stream.onData(this.reducerToResult.produceResult(accumulator));
            }
        }

        public static final class InputToAccumulator<K, I, O, A>
        implements Reducer<K, I, A, A> {
            private ReducerToResult<K, I, O, A> reducerToResult;

            public InputToAccumulator() {
            }

            public ReducerToResult<K, I, O, A> getReducerToResult() {
                return this.reducerToResult;
            }

            public void setReducerToResult(ReducerToResult<K, I, O, A> reducerToResult) {
                this.reducerToResult = reducerToResult;
            }

            public InputToAccumulator(ReducerToResult<K, I, O, A> reducerToResult) {
                this.reducerToResult = reducerToResult;
            }

            @Override
            public A onFirstItem(StreamDataReceiver<A> stream, K key, I firstValue) {
                A accumulator = this.reducerToResult.createAccumulator(key);
                return this.reducerToResult.accumulate(accumulator, firstValue);
            }

            @Override
            public A onNextItem(StreamDataReceiver<A> stream, K key, I nextValue, A accumulator) {
                return this.reducerToResult.accumulate(accumulator, nextValue);
            }

            @Override
            public void onComplete(StreamDataReceiver<A> stream, K key, A accumulator) {
                stream.onData(accumulator);
            }
        }

        public static final class InputToOutput<K, I, O, A>
        implements Reducer<K, I, O, A> {
            private ReducerToResult<K, I, O, A> reducerToResult;

            public InputToOutput() {
            }

            public InputToOutput(ReducerToResult<K, I, O, A> reducerToResult) {
                this.reducerToResult = reducerToResult;
            }

            public ReducerToResult<K, I, O, A> getReducerToResult() {
                return this.reducerToResult;
            }

            public void setReducerToResult(ReducerToResult<K, I, O, A> reducerToResult) {
                this.reducerToResult = reducerToResult;
            }

            @Override
            public final A onFirstItem(StreamDataReceiver<O> stream, K key, I firstValue) {
                A accumulator = this.reducerToResult.createAccumulator(key);
                return this.reducerToResult.accumulate(accumulator, firstValue);
            }

            @Override
            public final A onNextItem(StreamDataReceiver<O> stream, K key, I nextValue, A accumulator) {
                return this.reducerToResult.accumulate(accumulator, nextValue);
            }

            @Override
            public final void onComplete(StreamDataReceiver<O> stream, K key, A accumulator) {
                stream.onData(this.reducerToResult.produceResult(accumulator));
            }
        }
    }

    public static interface Reducer<K, I, O, A> {
        public A onFirstItem(StreamDataReceiver<O> var1, K var2, I var3);

        public A onNextItem(StreamDataReceiver<O> var1, K var2, I var3, A var4);

        public void onComplete(StreamDataReceiver<O> var1, K var2, A var3);
    }
}

