/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.stream.processor;

import io.datakernel.stream.AbstractStreamConsumer;
import io.datakernel.stream.AbstractStreamProducer;
import io.datakernel.stream.HasInput;
import io.datakernel.stream.HasOutputs;
import io.datakernel.stream.StreamConsumer;
import io.datakernel.stream.StreamDataReceiver;
import io.datakernel.stream.StreamProducer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class StreamSplitter<T>
implements HasInput<T>,
HasOutputs,
StreamDataReceiver<T> {
    private final Input input;
    private final List<Output> outputs = new ArrayList<Output>();
    private StreamDataReceiver<T>[] dataReceivers = new StreamDataReceiver[0];
    private int suspended = 0;

    private StreamSplitter() {
        this.input = new Input();
    }

    public static <T> StreamSplitter<T> create() {
        return new StreamSplitter<T>();
    }

    public StreamProducer<T> newOutput() {
        Output output = new Output(this.outputs.size());
        this.dataReceivers = Arrays.copyOf(this.dataReceivers, this.dataReceivers.length + 1);
        ++this.suspended;
        this.outputs.add(output);
        return output;
    }

    @Override
    public StreamConsumer<T> getInput() {
        return this.input;
    }

    public List<? extends StreamProducer<T>> getOutputs() {
        return this.outputs;
    }

    @Override
    public void onData(T item) {
        for (int i = 0; i < this.dataReceivers.length; ++i) {
            this.dataReceivers[i].onData(item);
        }
    }

    protected final class Output
    extends AbstractStreamProducer<T> {
        private final int index;

        protected Output(int index) {
            this.index = index;
        }

        @Override
        protected void onSuspended() {
            StreamSplitter.this.suspended++;
            StreamSplitter.this.input.getProducer().suspend();
        }

        @Override
        protected void onProduce(StreamDataReceiver<T> dataReceiver) {
            ((StreamSplitter)StreamSplitter.this).dataReceivers[this.index] = dataReceiver;
            if (--StreamSplitter.this.suspended == 0) {
                StreamSplitter.this.input.getProducer().produce(StreamSplitter.this);
            }
        }

        @Override
        protected void onError(Throwable t) {
            StreamSplitter.this.input.closeWithError(t);
        }
    }

    protected final class Input
    extends AbstractStreamConsumer<T> {
        protected Input() {
        }

        @Override
        protected void onStarted() {
            if (StreamSplitter.this.outputs.isEmpty()) {
                throw new IllegalStateException("Empty outputs");
            }
        }

        @Override
        protected void onEndOfStream() {
            StreamSplitter.this.outputs.forEach(AbstractStreamProducer::sendEndOfStream);
        }

        @Override
        protected void onError(Throwable t) {
            StreamSplitter.this.outputs.forEach(output -> output.closeWithError(t));
        }
    }
}

