/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.stream.processor;

import io.datakernel.stream.AbstractStreamConsumer;
import io.datakernel.stream.AbstractStreamProducer;
import io.datakernel.stream.StreamCapability;
import io.datakernel.stream.StreamConsumer;
import io.datakernel.stream.StreamDataReceiver;
import io.datakernel.stream.StreamProducer;
import io.datakernel.stream.processor.StreamTransformer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Set;

public class StreamSuspendBuffer<T>
implements StreamTransformer<T, T>,
StreamDataReceiver<T> {
    private final Input input;
    private final Output output;
    private final Deque<T> buffer = new ArrayDeque<T>();
    private final int minBuffered;
    private final int maxBuffered;
    private boolean suspended = false;
    private boolean finished = false;

    private StreamSuspendBuffer(int minBuffered, int maxBuffered) {
        this.minBuffered = minBuffered;
        this.maxBuffered = maxBuffered;
        this.input = new Input();
        this.output = new Output();
    }

    public static <T> StreamSuspendBuffer<T> create() {
        return new StreamSuspendBuffer<T>(0, 0);
    }

    public static <T> StreamSuspendBuffer<T> create(int minBuffered, int maxBuffered) {
        return new StreamSuspendBuffer<T>(minBuffered, maxBuffered);
    }

    @Override
    public void onData(T item) {
        if (this.suspended) {
            this.buffer.offer(item);
            if (this.buffer.size() >= this.maxBuffered) {
                this.input.getProducer().suspend();
            }
            return;
        }
        this.output.send(item);
    }

    @Override
    public StreamConsumer<T> getInput() {
        return this.input;
    }

    @Override
    public StreamProducer<T> getOutput() {
        return this.output;
    }

    protected final class Output
    extends AbstractStreamProducer<T> {
        protected Output() {
        }

        @Override
        protected void produce() {
            while (!StreamSuspendBuffer.this.buffer.isEmpty()) {
                if (!StreamSuspendBuffer.this.output.isReceiverReady()) {
                    return;
                }
                this.send(StreamSuspendBuffer.this.buffer.pop());
                if (StreamSuspendBuffer.this.buffer.size() >= StreamSuspendBuffer.this.minBuffered) continue;
                StreamSuspendBuffer.this.input.getProducer().produce(StreamSuspendBuffer.this);
            }
            if (StreamSuspendBuffer.this.output.isReceiverReady()) {
                StreamSuspendBuffer.this.suspended = false;
                StreamSuspendBuffer.this.input.getProducer().produce(StreamSuspendBuffer.this);
            }
            if (StreamSuspendBuffer.this.finished) {
                this.sendEndOfStream();
            }
        }

        @Override
        protected void onSuspended() {
            StreamSuspendBuffer.this.suspended = true;
            if (StreamSuspendBuffer.this.maxBuffered == 0) {
                StreamSuspendBuffer.this.input.getProducer().suspend();
            }
        }

        @Override
        public Set<StreamCapability> getCapabilities() {
            return Output.addCapabilities(StreamSuspendBuffer.this.input.getProducer(), StreamCapability.IMMEDIATE_SUSPEND, new StreamCapability[0]);
        }

        @Override
        protected void onError(Throwable t) {
            StreamSuspendBuffer.this.input.closeWithError(t);
        }
    }

    protected final class Input
    extends AbstractStreamConsumer<T> {
        protected Input() {
        }

        @Override
        public Set<StreamCapability> getCapabilities() {
            return Input.addCapabilities(StreamSuspendBuffer.this.output.getConsumer(), StreamCapability.IMMEDIATE_SUSPEND, new StreamCapability[0]);
        }

        @Override
        protected void onEndOfStream() {
            if (!StreamSuspendBuffer.this.suspended) {
                StreamSuspendBuffer.this.output.sendEndOfStream();
                return;
            }
            StreamSuspendBuffer.this.finished = true;
        }

        @Override
        protected void onError(Throwable t) {
            StreamSuspendBuffer.this.output.closeWithError(t);
        }
    }
}

