/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.stream.processor;

import io.datakernel.stream.DataStreams;
import io.datakernel.stream.HasInput;
import io.datakernel.stream.HasOutput;
import io.datakernel.stream.StreamConsumer;
import io.datakernel.stream.StreamConsumerModifier;
import io.datakernel.stream.StreamProducer;
import io.datakernel.stream.StreamProducerModifier;
import io.datakernel.stream.processor.StreamFunction;
import io.datakernel.stream.processor.StreamModifier;
import java.util.function.Function;

public interface StreamTransformer<I, O>
extends HasInput<I>,
HasOutput<O>,
StreamModifier<I, O> {
    public static <X> StreamTransformer<X, X> idenity() {
        return StreamFunction.create(Function.identity());
    }

    default public <T> StreamTransformer<T, O> with(final StreamConsumerModifier<I, T> consumerModifier) {
        return new StreamTransformer<T, O>(){
            private final StreamConsumer<T> input;
            {
                this.input = consumerModifier.applyTo(StreamTransformer.this.getInput());
            }

            @Override
            public StreamConsumer<T> getInput() {
                return this.input;
            }

            @Override
            public StreamProducer<O> getOutput() {
                return StreamTransformer.this.getOutput();
            }
        };
    }

    default public <T> StreamTransformer<I, T> with(final StreamProducerModifier<O, T> producerModifier) {
        return new StreamTransformer<I, T>(){
            private final StreamProducer<T> output;
            {
                this.output = producerModifier.applyTo(StreamTransformer.this.getOutput());
            }

            @Override
            public StreamConsumer<I> getInput() {
                return StreamTransformer.this.getInput();
            }

            @Override
            public StreamProducer<T> getOutput() {
                return this.output;
            }
        };
    }

    @Override
    default public StreamConsumer<I> applyTo(StreamConsumer<O> consumer) {
        DataStreams.bind(this.getOutput(), consumer);
        return this.getInput();
    }

    @Override
    default public StreamProducer<O> applyTo(StreamProducer<I> producer) {
        DataStreams.bind(producer, this.getInput());
        return this.getOutput();
    }
}

