/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.stream.stats;

import io.datakernel.jmx.JmxAttribute;
import io.datakernel.stream.StreamConsumer;
import io.datakernel.stream.StreamProducer;
import io.datakernel.stream.processor.StreamModifier;
import io.datakernel.util.CollectionUtils;
import io.datakernel.util.IntrusiveLinkedList;
import java.util.ArrayList;
import java.util.Iterator;

public final class StreamRegistry<V>
implements Iterable<V> {
    private final IntrusiveLinkedList<Entry<V>> list = IntrusiveLinkedList.create();
    private int limit = 10;

    public static <V> StreamRegistry<V> create() {
        return new StreamRegistry<V>();
    }

    public StreamRegistry<V> withLimit(int limit) {
        this.limit = limit;
        return this;
    }

    public <T> StreamModifier<T, T> newEntry(final V value) {
        return new StreamModifier<T, T>(){

            @Override
            public StreamConsumer<T> applyTo(StreamConsumer<T> consumer) {
                return StreamRegistry.this.newEntry(consumer, value);
            }

            @Override
            public StreamProducer<T> applyTo(StreamProducer<T> producer) {
                return StreamRegistry.this.newEntry(producer, value);
            }
        };
    }

    public <T> StreamConsumer<T> newEntry(StreamConsumer<T> consumer, V value) {
        Entry entry = new Entry(value);
        IntrusiveLinkedList.Node node = this.list.addFirstValue(entry);
        consumer.getEndOfStream().whenComplete(($, throwable) -> this.list.removeNode(node));
        return consumer;
    }

    public <T> StreamProducer<T> newEntry(StreamProducer<T> producer, V value) {
        Entry entry = new Entry(value);
        IntrusiveLinkedList.Node node = this.list.addFirstValue(entry);
        producer.getEndOfStream().whenComplete(($, throwable) -> this.list.removeNode(node));
        return producer;
    }

    @Override
    public Iterator<V> iterator() {
        final Iterator iterator = this.list.iterator();
        return new Iterator<V>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public V next() {
                return ((Entry)iterator.next()).operation;
            }
        };
    }

    @JmxAttribute(name="")
    public String getString() {
        ArrayList entries = new ArrayList();
        this.list.forEach(entries::add);
        return CollectionUtils.toLimitedString(entries, (int)this.limit);
    }

    public static class Entry<T> {
        private final long timestamp = System.currentTimeMillis();
        private final T operation;

        private Entry(T operation) {
            this.operation = operation;
        }

        public String toString() {
            return this.operation + " " + (System.currentTimeMillis() - this.timestamp);
        }
    }
}

