/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.stream.stats;

import io.datakernel.stream.StreamConsumer;
import io.datakernel.stream.StreamConsumerModifier;
import io.datakernel.stream.StreamDataReceiver;
import io.datakernel.stream.StreamProducer;
import io.datakernel.stream.StreamProducerModifier;
import io.datakernel.stream.stats.StreamStatsBasic;
import io.datakernel.stream.stats.StreamStatsDetailed;
import io.datakernel.stream.stats.StreamStatsDetailedEx;
import io.datakernel.stream.stats.StreamStatsForwarder;
import io.datakernel.stream.stats.StreamStatsSizeCounter;

public interface StreamStats<T>
extends StreamConsumerModifier<T, T>,
StreamProducerModifier<T, T> {
    public StreamDataReceiver<T> createDataReceiver(StreamDataReceiver<T> var1);

    public void onStarted();

    public void onProduce();

    public void onSuspend();

    public void onEndOfStream();

    public void onError(Throwable var1);

    @Override
    default public StreamConsumer<T> applyTo(StreamConsumer<T> consumer) {
        return consumer.with(StreamStatsForwarder.create(this));
    }

    @Override
    default public StreamProducer<T> applyTo(StreamProducer<T> producer) {
        return producer.with(StreamStatsForwarder.create(this));
    }

    public static <T> StreamStatsBasic<T> basic() {
        return new StreamStatsBasic();
    }

    public static <T> StreamStatsDetailed<T> detailed() {
        return new StreamStatsDetailed(null);
    }

    public static <T> StreamStatsDetailed<T> detailed(StreamStatsSizeCounter<T> sizeCounter) {
        return new StreamStatsDetailed(sizeCounter);
    }

    public static <T> StreamStatsDetailedEx<T> detailedEx() {
        return new StreamStatsDetailedEx(null);
    }

    public static <T> StreamStatsDetailedEx detailedEx(StreamStatsSizeCounter<T> sizeCounter) {
        return new StreamStatsDetailedEx(sizeCounter);
    }
}

