/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.stream.stats;

import io.datakernel.jmx.EventStats;
import io.datakernel.jmx.ExceptionStats;
import io.datakernel.jmx.JmxAttribute;
import io.datakernel.jmx.JmxReducers;
import io.datakernel.stream.StreamDataReceiver;
import io.datakernel.stream.stats.StreamStats;
import java.time.Duration;

public class StreamStatsBasic<T>
implements StreamStats<T> {
    public static final Duration DEFAULT_BASIC_SMOOTHING_WINDOW = Duration.ofMinutes(5L);
    private final EventStats started = EventStats.create((Duration)DEFAULT_BASIC_SMOOTHING_WINDOW);
    private final EventStats produce = EventStats.create((Duration)DEFAULT_BASIC_SMOOTHING_WINDOW);
    private final EventStats suspend = EventStats.create((Duration)DEFAULT_BASIC_SMOOTHING_WINDOW);
    private final EventStats endOfStream = EventStats.create((Duration)DEFAULT_BASIC_SMOOTHING_WINDOW);
    private final ExceptionStats error = ExceptionStats.create();

    public StreamStatsBasic withBasicSmoothingWindow(Duration smoothingWindow) {
        this.started.setSmoothingWindow(smoothingWindow);
        this.produce.setSmoothingWindow(smoothingWindow);
        this.suspend.setSmoothingWindow(smoothingWindow);
        this.endOfStream.setSmoothingWindow(smoothingWindow);
        return this;
    }

    @Override
    public StreamDataReceiver<T> createDataReceiver(StreamDataReceiver<T> actualDataReceiver) {
        return actualDataReceiver;
    }

    @Override
    public void onStarted() {
        this.started.recordEvent();
    }

    @Override
    public void onProduce() {
        this.produce.recordEvent();
    }

    @Override
    public void onSuspend() {
        this.suspend.recordEvent();
    }

    @Override
    public void onEndOfStream() {
        this.endOfStream.recordEvent();
    }

    @Override
    public void onError(Throwable throwable) {
        this.error.recordException(throwable);
    }

    @JmxAttribute
    public EventStats getStarted() {
        return this.started;
    }

    @JmxAttribute
    public EventStats getProduce() {
        return this.produce;
    }

    @JmxAttribute
    public EventStats getSuspend() {
        return this.suspend;
    }

    @JmxAttribute
    public EventStats getEndOfStream() {
        return this.endOfStream;
    }

    @JmxAttribute
    public ExceptionStats getError() {
        return this.error;
    }

    @JmxAttribute(reducer=JmxReducers.JmxReducerSum.class)
    public int getActive() {
        return (int)(this.started.getTotalCount() - (this.endOfStream.getTotalCount() + (long)this.error.getTotal()));
    }
}

