/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.stream.stats;

import io.datakernel.annotation.Nullable;
import io.datakernel.jmx.JmxAttribute;
import io.datakernel.jmx.JmxReducers;
import io.datakernel.jmx.JmxStatsWithReset;
import io.datakernel.stream.StreamDataReceiver;
import io.datakernel.stream.stats.StreamStatsBasic;
import io.datakernel.stream.stats.StreamStatsSizeCounter;
import io.datakernel.util.ReflectionUtils;
import java.time.Duration;

public final class StreamStatsDetailed<T>
extends StreamStatsBasic<T>
implements JmxStatsWithReset {
    @Nullable
    private final StreamStatsSizeCounter<Object> sizeCounter;
    private long count;
    private long totalSize;

    StreamStatsDetailed(StreamStatsSizeCounter<?> sizeCounter) {
        this.sizeCounter = sizeCounter;
    }

    @Override
    public StreamStatsDetailed withBasicSmoothingWindow(Duration smoothingWindow) {
        return (StreamStatsDetailed)super.withBasicSmoothingWindow(smoothingWindow);
    }

    @Override
    public StreamDataReceiver<T> createDataReceiver(StreamDataReceiver<T> actualDataReceiver) {
        return this.sizeCounter == null ? item -> {
            ++this.count;
            actualDataReceiver.onData(item);
        } : item -> {
            ++this.count;
            int size = this.sizeCounter.size(item);
            this.totalSize += (long)size;
            actualDataReceiver.onData(item);
        };
    }

    @JmxAttribute(reducer=JmxReducers.JmxReducerSum.class)
    public long getCount() {
        return this.count;
    }

    @JmxAttribute(reducer=JmxReducers.JmxReducerSum.class)
    public Long getTotalSize() {
        return this.sizeCounter != null ? Long.valueOf(this.totalSize) : null;
    }

    @JmxAttribute(reducer=JmxReducers.JmxReducerSum.class)
    public Long getTotalSizeAvg() {
        return this.sizeCounter != null && super.getStarted().getTotalCount() != 0L ? Long.valueOf(this.totalSize / super.getStarted().getTotalCount()) : null;
    }

    public void resetStats() {
        this.totalSize = 0L;
        this.count = 0L;
        ReflectionUtils.resetStats((Object)this);
    }
}

