/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.stream.stats;

import io.datakernel.annotation.Nullable;
import io.datakernel.jmx.EventStats;
import io.datakernel.jmx.JmxAttribute;
import io.datakernel.jmx.JmxReducers;
import io.datakernel.jmx.ValueStats;
import io.datakernel.stream.StreamDataReceiver;
import io.datakernel.stream.stats.StreamStatsBasic;
import io.datakernel.stream.stats.StreamStatsSizeCounter;
import java.time.Duration;

public final class StreamStatsDetailedEx<T>
extends StreamStatsBasic<T> {
    public static final Duration DEFAULT_DETAILED_SMOOTHING_WINDOW = Duration.ofMinutes(1L);
    @Nullable
    private final StreamStatsSizeCounter<Object> sizeCounter;
    private final EventStats count = EventStats.create((Duration)DEFAULT_DETAILED_SMOOTHING_WINDOW);
    private final ValueStats itemSize = ValueStats.create((Duration)DEFAULT_DETAILED_SMOOTHING_WINDOW);
    private final EventStats totalSize = EventStats.create((Duration)DEFAULT_DETAILED_SMOOTHING_WINDOW);

    StreamStatsDetailedEx(StreamStatsSizeCounter<?> sizeCounter) {
        this.sizeCounter = sizeCounter;
    }

    @Override
    public StreamStatsDetailedEx withBasicSmoothingWindow(Duration smoothingWindow) {
        return (StreamStatsDetailedEx)super.withBasicSmoothingWindow(smoothingWindow);
    }

    @Override
    public StreamDataReceiver<T> createDataReceiver(final StreamDataReceiver<T> actualDataReceiver) {
        return this.sizeCounter == null ? new StreamDataReceiver<T>(){
            final EventStats count;
            {
                this.count = StreamStatsDetailedEx.this.count;
            }

            @Override
            public void onData(T item) {
                this.count.recordEvent();
                actualDataReceiver.onData(item);
            }
        } : new StreamDataReceiver<T>(){
            final EventStats count;
            final ValueStats itemSize;
            {
                this.count = StreamStatsDetailedEx.this.count;
                this.itemSize = StreamStatsDetailedEx.this.itemSize;
            }

            @Override
            public void onData(T item) {
                this.count.recordEvent();
                int size = StreamStatsDetailedEx.this.sizeCounter.size(item);
                this.itemSize.recordValue(size);
                StreamStatsDetailedEx.this.totalSize.recordEvents(size);
                actualDataReceiver.onData(item);
            }
        };
    }

    public StreamStatsDetailedEx withSizeHistogram(int[] levels) {
        this.itemSize.setHistogramLevels(levels);
        return this;
    }

    @JmxAttribute
    public EventStats getCount() {
        return this.count;
    }

    @JmxAttribute
    public ValueStats getItemSize() {
        return this.sizeCounter != null ? this.itemSize : null;
    }

    @JmxAttribute
    public EventStats getTotalSize() {
        return this.sizeCounter != null ? this.totalSize : null;
    }

    @JmxAttribute(reducer=JmxReducers.JmxReducerSum.class)
    public Long getTotalSizeAvg() {
        return this.sizeCounter != null && super.getStarted().getTotalCount() != 0L ? Long.valueOf(this.totalSize.getTotalCount() / super.getStarted().getTotalCount()) : null;
    }
}

