/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.stream.stats;

import io.datakernel.bytebuf.ByteBuf;
import java.util.Collection;

public interface StreamStatsSizeCounter<T> {
    public int size(T var1);

    public static StreamStatsSizeCounter<ByteBuf> forByteBufs() {
        return ByteBuf::readRemaining;
    }

    public static <T extends Collection<?>> StreamStatsSizeCounter<T> forCollections() {
        return Collection::size;
    }

    public static <T> StreamStatsSizeCounter<T[]> forArrays() {
        return item -> ((Object[])item).length;
    }

    public static StreamStatsSizeCounter<String> forStrings() {
        return String::length;
    }
}

