/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.async;

import io.datakernel.annotation.Nullable;
import io.datakernel.async.NextStage;
import io.datakernel.async.SettableStage;
import io.datakernel.async.Stage;
import io.datakernel.async.StageConsumer;
import io.datakernel.eventloop.Eventloop;
import io.datakernel.eventloop.ScheduledRunnable;
import io.datakernel.functional.Try;
import io.datakernel.util.Preconditions;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

abstract class AbstractStage<T>
implements Stage<T> {
    private static final StageConsumer<Object> COMPLETED_STAGE = (t, throwable) -> {
        throw new UnsupportedOperationException();
    };
    protected StageConsumer<? super T> next;
    private static final Object NO_RESULT = new Object();

    AbstractStage() {
    }

    public boolean isComplete() {
        return this.next == COMPLETED_STAGE;
    }

    protected void complete(@Nullable T value, @Nullable Throwable error) {
        assert (!this.isComplete());
        if (error == null) {
            this.complete(value);
        } else {
            this.completeExceptionally(error);
        }
    }

    protected void complete(@Nullable T value) {
        assert (!this.isComplete());
        if (this.next != null) {
            this.next.accept(value, null);
            this.next = COMPLETED_STAGE;
        }
        assert ((this.next = COMPLETED_STAGE) != null);
    }

    protected void completeExceptionally(@Nullable Throwable error) {
        assert (!this.isComplete());
        if (this.next != null) {
            this.next.accept(null, error);
            this.next = COMPLETED_STAGE;
        }
        assert ((this.next = COMPLETED_STAGE) != null);
    }

    protected void tryComplete(@Nullable T value, @Nullable Throwable error) {
        if (!this.isComplete()) {
            this.complete(value, error);
        }
    }

    protected void tryComplete(T value) {
        if (!this.isComplete()) {
            this.complete(value);
        }
    }

    protected void tryCompleteExceptionally(Throwable error) {
        if (!this.isComplete()) {
            this.completeExceptionally(error);
        }
    }

    @Override
    public <U, S extends StageConsumer<? super T> & Stage<U>> Stage<U> then(S stage) {
        this.subscribe(stage);
        return stage;
    }

    protected void subscribe(StageConsumer<? super T> consumer) {
        if (this.next == null) {
            this.next = consumer;
        } else {
            assert (this.next != COMPLETED_STAGE) : "Stage has already been completed";
            if (consumer instanceof NextStage) {
                NextStage nextStage = (NextStage)consumer;
                assert (nextStage.next == null);
                nextStage.prev = this.next;
                this.next = consumer;
            } else {
                StageConsumer finalNext = this.next;
                this.next = (result, error) -> {
                    finalNext.accept(result, error);
                    consumer.accept(result, error);
                };
            }
        }
    }

    @Override
    public <U> Stage<U> thenApply(final Function<? super T, ? extends U> fn) {
        return this.then((StageConsumer<? super T> & Stage<U>)new NextStage<T, U>(){

            @Override
            protected void onComplete(T result) {
                Object newResult = fn.apply(result);
                this.complete(newResult);
            }
        });
    }

    @Override
    public <U> Stage<U> thenApplyEx(final BiFunction<? super T, Throwable, ? extends U> fn) {
        return this.then((StageConsumer<? super T> & Stage<U>)new NextStage<T, U>(){

            @Override
            protected void onComplete(T result) {
                Object newResult = fn.apply(result, null);
                this.complete(newResult);
            }

            @Override
            protected void onCompleteExceptionally(Throwable throwable) {
                Object newResult = fn.apply(null, throwable);
                this.complete(newResult);
            }
        });
    }

    @Override
    public Stage<T> whenResult(Consumer<? super T> action) {
        return this.whenComplete((result, throwable) -> {
            if (throwable == null) {
                action.accept(result);
            }
        });
    }

    @Override
    public Stage<T> thenRun(Runnable action) {
        return this.whenComplete((result, throwable) -> {
            if (throwable == null) {
                action.run();
            }
        });
    }

    @Override
    public Stage<T> thenRunEx(Runnable action) {
        return this.whenComplete((result, throwable) -> action.run());
    }

    @Override
    public <U> Stage<U> thenCompose(final Function<? super T, ? extends Stage<U>> fn) {
        return this.then((StageConsumer<? super T> & Stage<U>)new NextStage<T, U>(){

            @Override
            protected void onComplete(T value) {
                SettableStage settableStage;
                Stage stage = (Stage)fn.apply(value);
                if (stage instanceof SettableStage && (settableStage = (SettableStage)stage).isSet()) {
                    if (settableStage.exception == null) {
                        this.complete(settableStage.result);
                    } else {
                        this.completeExceptionally(settableStage.exception);
                    }
                    return;
                }
                stage.whenComplete(this::complete);
            }
        });
    }

    @Override
    public <U> Stage<U> thenComposeEx(final BiFunction<? super T, Throwable, ? extends Stage<U>> fn) {
        return this.then((StageConsumer<? super T> & Stage<U>)new NextStage<T, U>(){

            private void handleComplete(T value, Throwable throwable) {
                SettableStage settableStage;
                Stage stage = (Stage)fn.apply(value, throwable);
                if (stage instanceof SettableStage && (settableStage = (SettableStage)stage).isSet()) {
                    if (settableStage.exception == null) {
                        this.complete(settableStage.result);
                    } else {
                        this.completeExceptionally(settableStage.exception);
                    }
                    return;
                }
                stage.whenComplete(this::complete);
            }

            @Override
            protected void onComplete(T result) {
                this.handleComplete(result, null);
            }

            @Override
            protected void onCompleteExceptionally(Throwable throwable) {
                this.handleComplete(null, throwable);
            }
        });
    }

    @Override
    public Stage<T> whenComplete(StageConsumer<? super T> action) {
        this.subscribe(action);
        return this;
    }

    @Override
    public Stage<T> whenException(Consumer<Throwable> action) {
        return this.whenComplete((result, throwable) -> {
            if (throwable != null) {
                action.accept(throwable);
            }
        });
    }

    @Override
    public <U, V> Stage<V> combine(Stage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        StageCombine resultStage = new StageCombine(fn);
        other.whenComplete((result, throwable) -> {
            if (throwable == null) {
                resultStage.onOtherComplete(result);
            } else {
                resultStage.onAnyException(throwable);
            }
        });
        return this.then((StageConsumer<? super T> & Stage<U>)resultStage);
    }

    @Override
    public Stage<Void> both(Stage<?> other) {
        StageBoth resultStage = new StageBoth();
        other.whenComplete((result, throwable) -> {
            if (throwable == null) {
                if (--resultStage.counter == 0) {
                    resultStage.complete(null);
                }
            } else {
                resultStage.tryCompleteExceptionally(throwable);
            }
        });
        return this.then((StageConsumer<? super T> & Stage<U>)resultStage);
    }

    @Override
    public Stage<T> either(Stage<? extends T> other) {
        EitherStage resultStage = new EitherStage();
        other.whenComplete((result, throwable) -> {
            if (throwable == null) {
                resultStage.tryComplete(result);
            } else if (++resultStage.errors == 2) {
                resultStage.completeExceptionally(throwable);
            }
        });
        return this.then((StageConsumer<? super T> & Stage<U>)resultStage);
    }

    @Override
    public Stage<T> post() {
        return this.then((StageConsumer<? super T> & Stage<U>)new NextStage<T, T>(){

            @Override
            protected void onComplete(T result) {
                Eventloop.getCurrentEventloop().post(() -> this.complete(result));
            }

            @Override
            protected void onCompleteExceptionally(Throwable throwable) {
                Eventloop.getCurrentEventloop().post(() -> this.completeExceptionally(throwable));
            }
        });
    }

    @Override
    public Stage<Try<T>> toTry() {
        return this.then((StageConsumer<? super T> & Stage<U>)new NextStage<T, Try<T>>(){

            @Override
            protected void onComplete(T result) {
                this.complete(Try.of(result));
            }

            @Override
            protected void onCompleteExceptionally(Throwable throwable) {
                this.complete(Try.ofFailure((Throwable)throwable));
            }
        });
    }

    @Override
    public Stage<Void> toVoid() {
        return this.thenApply($ -> null);
    }

    @Override
    public Stage<T> timeout(Duration timeout) {
        Preconditions.checkArgument((timeout.toMillis() >= 0L ? 1 : 0) != 0, (Object)"Timeout cannot be less than zero");
        if (timeout.equals(Duration.ZERO)) {
            return this;
        }
        final ScheduledRunnable schedule = Eventloop.getCurrentEventloop().delay(timeout, () -> this.tryCompleteExceptionally((Throwable)TIMEOUT_EXCEPTION));
        return this.then((StageConsumer<? super T> & Stage<U>)new NextStage<T, T>(){

            @Override
            protected void onComplete(T result) {
                schedule.cancel();
                this.tryComplete(result);
            }

            @Override
            protected void onCompleteExceptionally(Throwable throwable) {
                schedule.cancel();
                this.tryCompleteExceptionally(throwable);
            }
        });
    }

    @Override
    public CompletableFuture<T> toCompletableFuture() {
        CompletableFuture future = new CompletableFuture();
        this.subscribe((result, throwable) -> {
            if (throwable == null) {
                future.complete(result);
            } else {
                future.completeExceptionally(throwable);
            }
        });
        return future;
    }

    private static final class EitherStage<T>
    extends NextStage<T, T> {
        int errors;

        private EitherStage() {
        }

        @Override
        protected void onComplete(T result) {
            this.tryComplete(result);
        }

        @Override
        protected void onCompleteExceptionally(Throwable throwable) {
            if (++this.errors == 2) {
                this.completeExceptionally(throwable);
            }
        }
    }

    private static class StageBoth<T>
    extends NextStage<T, Void> {
        int counter = 2;

        private StageBoth() {
        }

        @Override
        protected void onComplete(T thisResult) {
            if (--this.counter == 0) {
                this.complete(null);
            }
        }

        @Override
        protected void onCompleteExceptionally(Throwable throwable) {
            this.tryCompleteExceptionally(throwable);
        }
    }

    private static class StageCombine<T, V, U>
    extends NextStage<T, V> {
        final BiFunction<? super T, ? super U, ? extends V> fn;
        T thisResult = AbstractStage.access$000();
        U otherResult = AbstractStage.access$000();

        StageCombine(BiFunction<? super T, ? super U, ? extends V> fn) {
            this.fn = fn;
        }

        @Override
        protected void onComplete(T thisResult) {
            if (this.otherResult != NO_RESULT) {
                this.onBothResults(thisResult, this.otherResult);
            } else {
                this.thisResult = thisResult;
            }
        }

        protected void onOtherComplete(U otherResult) {
            if (this.thisResult != NO_RESULT) {
                this.onBothResults(this.thisResult, otherResult);
            } else {
                this.otherResult = otherResult;
            }
        }

        void onBothResults(T thisResult, U otherResult) {
            this.thisResult = null;
            this.otherResult = null;
            if (!this.isComplete()) {
                this.complete(this.fn.apply(thisResult, otherResult));
            }
        }

        void onAnyException(Throwable throwable) {
            this.tryCompleteExceptionally(throwable);
        }

        @Override
        protected void onCompleteExceptionally(Throwable throwable) {
            this.onAnyException(throwable);
        }
    }
}

