/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.async;

import io.datakernel.async.AsyncCallable;
import io.datakernel.async.Stage;
import java.util.Objects;
import java.util.function.Function;

public interface AsyncFunction<T, R> {
    public Stage<R> apply(T var1);

    default public <U> AsyncFunction<U, R> compose(Function<? super U, ? extends T> before) {
        return t -> this.apply(before.apply((Object)t));
    }

    default public <U> AsyncFunction<U, R> compose(AsyncFunction<? super U, ? extends T> before) {
        return input -> before.apply((Object)input).thenCompose(this::apply);
    }

    default public <U> AsyncFunction<T, U> andThen(Function<? super R, ? extends U> after) {
        Objects.requireNonNull(after);
        return i -> this.apply(i).thenApply(after);
    }

    default public <U> AsyncFunction<T, U> andThen(AsyncFunction<? super R, ? extends U> after) {
        Objects.requireNonNull(after);
        return i -> this.apply(i).thenCompose(input -> after.apply((Object)input));
    }

    default public AsyncCallable<R> asAsyncCallable(T argument) {
        return AsyncCallable.of(this, argument);
    }

    public static <T, R> AsyncFunction<T, R> of(Function<T, R> function) {
        return input -> Stage.of(function.apply(input));
    }

    public static <T> AsyncFunction<T, T> identity() {
        return Stage::of;
    }
}

