/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.async;

import io.datakernel.async.Stage;
import java.util.Objects;
import java.util.function.Predicate;

public interface AsyncPredicate<T> {
    public Stage<Boolean> test(T var1);

    default public AsyncPredicate<T> negate() {
        return t -> this.test(t).thenApply(b -> b == false);
    }

    default public AsyncPredicate<T> and(AsyncPredicate<? super T> other) {
        Objects.requireNonNull(other);
        return t -> this.test(t).thenCompose(b -> b != false ? other.test(t) : Stage.of(Boolean.FALSE));
    }

    default public AsyncPredicate<T> and(Predicate<? super T> other) {
        Objects.requireNonNull(other);
        return t -> this.test(t).thenApply(b -> b != false ? other.test(t) : Boolean.FALSE.booleanValue());
    }

    default public AsyncPredicate<T> or(Predicate<? super T> other) {
        Objects.requireNonNull(other);
        return t -> this.test(t).thenApply(b -> b != false ? Boolean.TRUE.booleanValue() : other.test(t));
    }

    default public AsyncPredicate<T> or(AsyncPredicate<? super T> other) {
        Objects.requireNonNull(other);
        return t -> this.test(t).thenCompose(b -> b != false ? Stage.of(Boolean.TRUE) : other.test(t));
    }

    public static <T> AsyncPredicate<T> of(Predicate<T> predicate) {
        return t -> Stage.of(predicate.test(t));
    }

    public static <T> AsyncPredicate<T> alwaysTrue() {
        return t -> Stage.of(Boolean.TRUE);
    }

    public static <T> AsyncPredicate<T> alwaysFalse() {
        return t -> Stage.of(Boolean.FALSE);
    }
}

