/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.async;

import io.datakernel.async.SettableStage;
import io.datakernel.async.Stage;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;

public interface Callback<T> {
    public static final Callback<Object> IGNORE_CALLBACK = new Callback<Object>(){

        @Override
        public void set(Object result) {
        }

        @Override
        public void setException(Throwable t) {
        }
    };

    public void set(T var1);

    public void setException(Throwable var1);

    default public void set(T result, Throwable throwable) {
        if (throwable == null) {
            this.set(result);
        } else {
            this.setException(throwable);
        }
    }

    public static <T> void stageToCallback(Stage<T> stage, Callback<T> callback) {
        SettableStage settableStage;
        if (stage instanceof SettableStage && (settableStage = (SettableStage)stage).isSet()) {
            callback.set(settableStage.result, settableStage.exception);
            return;
        }
        stage.whenComplete(callback::set);
    }

    public static <T> Callback<T> ignore() {
        return IGNORE_CALLBACK;
    }

    public static <T> Callback<T> forBiConsumer(final BiConsumer<T, Throwable> biConsumer) {
        return new Callback<T>(){

            @Override
            public void set(T result) {
                biConsumer.accept(result, null);
            }

            @Override
            public void setException(Throwable t) {
                biConsumer.accept(null, t);
            }
        };
    }

    public static <T> Callback<T> forFuture(final CompletableFuture<T> future) {
        return new Callback<T>(){

            @Override
            public void set(T result) {
                future.complete(result);
            }

            @Override
            public void setException(Throwable t) {
                future.completeExceptionally(t);
            }
        };
    }

    public static <T> Callback<T> assertNoExceptions() {
        return new Callback<T>(){

            @Override
            public void set(T result) {
            }

            @Override
            public void setException(Throwable t) {
                throw new AssertionError((Object)t);
            }
        };
    }

    public static <T> Callback<T> assertNoCalls() {
        return new Callback<T>(){

            @Override
            public void set(T result) {
                throw new AssertionError();
            }

            @Override
            public void setException(Throwable t) {
                throw new AssertionError((Object)t);
            }
        };
    }
}

