/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.async;

import io.datakernel.async.Stages;
import io.datakernel.eventloop.Eventloop;

public interface CollectListener<T, A, R> {
    public void onStart(CollectCanceller var1, A var2);

    default public void onResult(T result, int index) {
    }

    default public void onException(Throwable throwable, int index) {
    }

    default public void onCollectResult(R result) {
    }

    default public void onCollectException(Throwable throwable) {
    }

    public static <T, A, R> CollectListener<T, A, R> timeout(long timeout) {
        Stages.ReduceTimeouter timeouter = new Stages.ReduceTimeouter();
        timeouter.scheduledRunnable = Eventloop.getCurrentEventloop().delay(timeout, timeouter);
        return timeouter;
    }

    public static <T, A, R> CollectListener<T, A, R> any(final int results) {
        return new CollectListener<T, A, R>(){
            CollectCanceller canceller;
            int counter;
            {
                this.counter = results;
            }

            @Override
            public void onStart(CollectCanceller canceller, A accumulator) {
                this.canceller = canceller;
            }

            @Override
            public void onResult(T result, int index) {
                if (--this.counter == 0) {
                    this.canceller.finish();
                }
            }
        };
    }

    public static interface CollectCanceller {
        public void finish();

        public void finishExceptionally(Throwable var1);
    }
}

