/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.async;

import io.datakernel.annotation.Nullable;
import io.datakernel.async.AsyncCallable;
import io.datakernel.async.RetryPolicy;
import io.datakernel.async.Stage;
import io.datakernel.eventloop.Eventloop;
import io.datakernel.eventloop.EventloopService;
import io.datakernel.eventloop.ScheduledRunnable;
import io.datakernel.jmx.EventloopJmxMBeanEx;
import io.datakernel.jmx.JmxAttribute;
import io.datakernel.jmx.JmxOperation;
import io.datakernel.jmx.StageStats;
import io.datakernel.util.Initializable;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EventloopTaskScheduler
implements EventloopService,
Initializable<EventloopTaskScheduler>,
EventloopJmxMBeanEx {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Eventloop eventloop;
    private final AsyncCallable<?> task;
    private final StageStats stats = StageStats.create(Duration.ofMinutes(5L));
    private long initialDelay;
    private Schedule schedule;
    private RetryPolicy retryPolicy;
    private boolean abortOnError = false;
    private long lastStartTime;
    private long lastCompleteTime;
    private Throwable lastException;
    private long firstRetryTime;
    private int errorCount;
    private Duration period;
    private Duration interval;
    private boolean enabled = true;
    private ScheduledRunnable scheduledTask;
    private final AsyncCallable<Void> doCall = AsyncCallable.sharedCall(this::doCall);

    private EventloopTaskScheduler(Eventloop eventloop, AsyncCallable<?> task) {
        this.eventloop = eventloop;
        this.task = task;
    }

    public static EventloopTaskScheduler create(Eventloop eventloop, AsyncCallable<?> task) {
        return new EventloopTaskScheduler(eventloop, task);
    }

    public EventloopTaskScheduler withInitialDelay(Duration initialDelay) {
        this.initialDelay = initialDelay.toMillis();
        return this;
    }

    public EventloopTaskScheduler withSchedule(Schedule schedule) {
        this.schedule = schedule;
        this.period = null;
        this.interval = null;
        return this;
    }

    public EventloopTaskScheduler withPeriod(Duration period) {
        this.setPeriod(period);
        return this;
    }

    public EventloopTaskScheduler withInterval(Duration interval) {
        this.setInterval(interval);
        return this;
    }

    public EventloopTaskScheduler withRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public EventloopTaskScheduler withAbortOnError(boolean abortOnError) {
        this.abortOnError = abortOnError;
        return this;
    }

    public EventloopTaskScheduler withStatsHistogramLevels(int[] levels) {
        this.stats.setHistogramLevels(levels);
        return this;
    }

    @Override
    public Eventloop getEventloop() {
        return this.eventloop;
    }

    private void scheduleTask() {
        long timestamp;
        if (this.scheduledTask != null && this.scheduledTask.isCancelled()) {
            return;
        }
        if (!this.enabled) {
            return;
        }
        long now = this.eventloop.currentTimeMillis();
        if (this.lastStartTime == 0L) {
            timestamp = now + this.initialDelay;
        } else if (this.lastException == null || this.retryPolicy == null) {
            timestamp = this.schedule.nextTimestamp(now, this.lastStartTime, this.lastCompleteTime);
        } else {
            assert (this.errorCount != 0);
            if (this.firstRetryTime == 0L) {
                this.firstRetryTime = now;
            }
            if ((timestamp = this.retryPolicy.nextRetryTimestamp(now, this.lastException, this.errorCount - 1, this.firstRetryTime)) == 0L) {
                timestamp = this.schedule.nextTimestamp(now, this.lastStartTime, this.lastCompleteTime);
            }
        }
        this.scheduledTask = this.eventloop.scheduleBackground(timestamp, this.doCall::call);
    }

    private Stage<Void> doCall() {
        this.lastStartTime = this.eventloop.currentTimeMillis();
        return this.task.call().whenComplete(this.stats.recordStats()).whenComplete((result, throwable) -> {
            this.lastCompleteTime = this.eventloop.currentTimeMillis();
            if (throwable == null) {
                this.firstRetryTime = 0L;
                this.lastException = null;
                this.errorCount = 0;
                this.scheduleTask();
            } else {
                this.lastException = throwable;
                ++this.errorCount;
                this.logger.error("Retry attempt " + this.errorCount, throwable);
                if (this.abortOnError) {
                    this.scheduledTask.cancel();
                    throw new RuntimeException(throwable);
                }
                this.scheduleTask();
            }
        }).toVoid();
    }

    @Override
    public Stage<Void> start() {
        this.scheduleTask();
        return Stage.of(null);
    }

    @Override
    public Stage<Void> stop() {
        this.scheduledTask.cancel();
        return Stage.of(null);
    }

    public void setSchedule(Schedule schedule) {
        this.schedule = schedule;
        if (this.stats.getActiveStages() != 0L && this.scheduledTask != null && !this.scheduledTask.isCancelled()) {
            this.scheduledTask.cancel();
            this.scheduledTask = null;
            this.scheduleTask();
        }
    }

    public void setRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        if (this.stats.getActiveStages() != 0L && this.scheduledTask != null && !this.scheduledTask.isCancelled() && this.lastException != null) {
            this.scheduledTask.cancel();
            this.scheduledTask = null;
            this.scheduleTask();
        }
    }

    @JmxAttribute
    public boolean isEnabled() {
        return this.enabled;
    }

    @JmxAttribute
    public void setEnabled(boolean enabled) {
        if (this.enabled == enabled) {
            return;
        }
        this.enabled = enabled;
        if (this.stats.getActiveStages() == 0L) {
            if (enabled) {
                this.scheduleTask();
            } else if (this.scheduledTask != null && !this.scheduledTask.isCancelled()) {
                this.scheduledTask.cancel();
                this.scheduledTask = null;
            }
        }
    }

    @JmxAttribute(name="")
    public StageStats getStats() {
        return this.stats;
    }

    @JmxAttribute
    public Throwable getLastException() {
        return this.lastException;
    }

    @JmxAttribute
    public long getInitialDelay() {
        return this.initialDelay;
    }

    @JmxAttribute
    @Nullable
    public Duration getPeriod() {
        return this.period;
    }

    @JmxAttribute
    public void setPeriod(Duration period) {
        Schedule schedule = Schedule.ofPeriod(period);
        this.setSchedule(schedule);
        this.period = period;
        this.interval = null;
    }

    @JmxAttribute
    @Nullable
    public Duration getInterval() {
        return this.interval;
    }

    @JmxAttribute
    public void setInterval(Duration interval) {
        this.setSchedule(Schedule.ofInterval(interval));
        this.period = null;
        this.interval = interval;
    }

    @JmxOperation
    public void startNow() {
        this.doCall.call();
    }

    public static interface Schedule {
        public long nextTimestamp(long var1, long var3, long var5);

        public static Schedule immediate() {
            return (now, lastStartTime, lastCompleteTime) -> now;
        }

        public static Schedule ofDelay(Duration delay) {
            return Schedule.ofDelay(delay.toMillis());
        }

        public static Schedule ofDelay(long delay) {
            return (now, lastStartTime, lastCompleteTime) -> now + delay;
        }

        public static Schedule ofInterval(Duration interval) {
            return Schedule.ofInterval(interval.toMillis());
        }

        public static Schedule ofInterval(long interval) {
            return (now, lastStartTime, lastCompleteTime) -> lastCompleteTime + interval;
        }

        public static Schedule ofPeriod(Duration period) {
            return Schedule.ofPeriod(period.toMillis());
        }

        public static Schedule ofPeriod(long period) {
            return (now, lastStartTime, lastCompleteTime) -> lastStartTime + period;
        }
    }
}

