/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.async;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collector;

public interface IndexedCollector<T, A, R> {
    public static final IndexedCollector<Object, Object[], Object[]> TO_ARRAY = new IndexedCollector<Object, Object[], Object[]>(){

        @Override
        public Object[] accumulator(int stages) {
            return new Object[stages];
        }

        @Override
        public void accumulate(Object[] accumulator, int stageIndex, Object stageResult) {
            accumulator[stageIndex] = stageResult;
        }

        @Override
        public Object[] finish(Object[] accumulator) {
            return accumulator;
        }

        @Override
        public Object[] resultOf() {
            return new Object[0];
        }

        @Override
        public Object[] resultOf(Object value1) {
            return new Object[]{value1};
        }

        @Override
        public Object[] resultOf(Object value1, Object value2) {
            return new Object[]{value1, value2};
        }

        @Override
        public Object[] resultOf(List<?> values) {
            return values.toArray(new Object[values.size()]);
        }
    };
    public static final IndexedCollector<Object, Object[], List<Object>> TO_LIST = new IndexedCollector<Object, Object[], List<Object>>(){

        @Override
        public Object[] accumulator(int stages) {
            return new Object[stages];
        }

        @Override
        public void accumulate(Object[] accumulator, int stageIndex, Object stageResult) {
            accumulator[stageIndex] = stageResult;
        }

        @Override
        public List<Object> finish(Object[] accumulator) {
            return Arrays.asList(accumulator);
        }

        @Override
        public List<Object> resultOf() {
            return Collections.emptyList();
        }

        @Override
        public List<Object> resultOf(Object value1) {
            return Collections.singletonList(value1);
        }

        @Override
        public List<Object> resultOf(Object value1, Object value2) {
            return Arrays.asList(value1, value2);
        }

        @Override
        public List<Object> resultOf(List<?> values) {
            return values;
        }
    };

    public A accumulator(int var1);

    public void accumulate(A var1, int var2, T var3);

    public R finish(A var1);

    default public R resultOf() {
        return this.resultOf(Collections.emptyList());
    }

    default public R resultOf(T value1) {
        return this.resultOf(Collections.singletonList(value1));
    }

    default public R resultOf(T value1, T value2) {
        return this.resultOf(Arrays.asList(value1, value2));
    }

    default public R resultOf(List<? extends T> values) {
        A accumulator = this.accumulator(values.size());
        for (int i = 0; i < values.size(); ++i) {
            this.accumulate(accumulator, i, values.get(i));
        }
        return this.finish(accumulator);
    }

    public static <T, A, R> IndexedCollector<T, A, R> ofCollector(final Collector<T, A, R> collector) {
        return new IndexedCollector<T, A, R>(){
            final BiConsumer<A, T> accumulator;
            {
                this.accumulator = collector.accumulator();
            }

            @Override
            public A accumulator(int stages) {
                return collector.supplier().get();
            }

            @Override
            public void accumulate(A accumulator, int stageIndex, T stageResult) {
                this.accumulator.accept(accumulator, stageResult);
            }

            @Override
            public R finish(A accumulator) {
                return collector.finisher().apply(accumulator);
            }
        };
    }

    public static <T> IndexedCollector<T, Object[], List<T>> toList() {
        return TO_LIST;
    }

    public static <T> IndexedCollector<T, T[], T[]> toArray() {
        return TO_ARRAY;
    }
}

