/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.async;

import io.datakernel.util.Preconditions;
import java.time.Duration;

public interface RetryPolicy {
    public long nextRetryTimestamp(long var1, Throwable var3, int var4, long var5);

    public static RetryPolicy noRetry() {
        return (now, lastError, retryCount, retryTimestamp) -> 0L;
    }

    public static RetryPolicy immediateRetry() {
        return (now, lastError, retryCount, retryTimestamp) -> now;
    }

    public static RetryPolicy fixedDelay(long delay) {
        return (now, lastError, retryCount, retryTimestamp) -> now + delay;
    }

    public static RetryPolicy exponentialBackoff(long initialDelay, long maxDelay, double exponent) {
        Preconditions.checkArgument((maxDelay > initialDelay && exponent > 1.0 ? 1 : 0) != 0);
        int maxRetryCount = (int)Math.ceil(Math.log(maxDelay / initialDelay) / Math.log(exponent));
        return (now, lastError, retryCount, retryTimestamp) -> now + (retryCount > maxRetryCount ? maxDelay : Math.min(maxDelay, (long)((double)initialDelay * Math.pow(exponent, retryCount))));
    }

    public static RetryPolicy exponentialBackoff(long initialDelay, long maxDelay) {
        return RetryPolicy.exponentialBackoff(initialDelay, maxDelay, 2.0);
    }

    default public RetryPolicy withMaxTotalRetryCount(int maxRetryCount) {
        return (now, lastError, retryCount, errorTimestamp) -> retryCount < maxRetryCount ? this.nextRetryTimestamp(now, lastError, retryCount, errorTimestamp) : 0L;
    }

    default public RetryPolicy withMaxTotalRetryTimeout(Duration maxRetryTimeout) {
        return (now, lastError, retryCount, retryTimestamp) -> {
            long nextRetryTimestamp = this.nextRetryTimestamp(now, lastError, retryCount, retryTimestamp);
            return nextRetryTimestamp - retryTimestamp < maxRetryTimeout.toMillis() ? nextRetryTimestamp : 0L;
        };
    }
}

