/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.async;

import io.datakernel.annotation.Nullable;
import io.datakernel.async.AbstractStage;
import io.datakernel.async.Callback;
import io.datakernel.async.StageConsumer;
import io.datakernel.eventloop.Eventloop;

public final class SettableStage<T>
extends AbstractStage<T>
implements Callback<T> {
    private static final Object NO_RESULT = new Object();
    @Nullable
    protected T result = NO_RESULT;
    @Nullable
    protected Throwable exception;

    protected SettableStage() {
    }

    public static <T> SettableStage<T> create() {
        return new SettableStage<T>();
    }

    @Override
    public void set(@Nullable T result) {
        assert (!this.isSet());
        if (this.next == null) {
            this.result = result;
        } else {
            this.result = null;
            this.complete(result);
        }
    }

    @Override
    public void setException(Throwable t) {
        assert (!this.isSet());
        if (this.next == null) {
            this.result = null;
            this.exception = t;
        } else {
            this.result = null;
            this.completeExceptionally(t);
        }
    }

    public boolean trySet(@Nullable T result) {
        if (this.isSet()) {
            return false;
        }
        this.set(result);
        return true;
    }

    public boolean trySetException(Throwable t) {
        if (this.isSet()) {
            return false;
        }
        this.setException(t);
        return true;
    }

    public boolean trySet(@Nullable T result, @Nullable Throwable throwable) {
        if (this.isSet()) {
            return false;
        }
        if (throwable == null) {
            this.trySet(result);
        } else {
            this.trySetException(throwable);
        }
        return true;
    }

    @Override
    protected void subscribe(StageConsumer<? super T> next) {
        if (this.isSet() && this.next == null) {
            Eventloop.getCurrentEventloop().post(() -> {
                if (this.exception == null) {
                    this.complete(this.result);
                } else {
                    this.completeExceptionally(this.exception);
                }
                this.result = null;
                this.exception = null;
            });
        }
        super.subscribe(next);
    }

    public boolean isSet() {
        return this.result != NO_RESULT;
    }

    public String toString() {
        return "SettableStage{" + String.valueOf(this.isSet() ? (this.exception == null ? "result=" + this.result : "exception=" + this.exception.getClass().getSimpleName()) : "<uncomplete>") + '}';
    }
}

