/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.async;

import io.datakernel.annotation.Nullable;
import io.datakernel.async.SettableStage;
import io.datakernel.async.StageConsumer;
import io.datakernel.eventloop.Eventloop;
import io.datakernel.exception.AsyncTimeoutException;
import io.datakernel.functional.Try;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public interface Stage<T> {
    public static final AsyncTimeoutException TIMEOUT_EXCEPTION = new AsyncTimeoutException("Stage timeout");

    public static <T> Stage<T> of(@Nullable T value) {
        SettableStage stage = new SettableStage();
        stage.result = value;
        return stage;
    }

    public static <T> Stage<T> ofException(Throwable throwable) {
        SettableStage stage = new SettableStage();
        stage.result = null;
        stage.exception = throwable;
        return stage;
    }

    public static <T> Stage<T> ofFuture(CompletableFuture<? extends T> future) {
        return Stage.ofCompletionStage(future);
    }

    public static <T> Stage<T> ofCompletionStage(CompletionStage<? extends T> completionStage) {
        Eventloop eventloop = Eventloop.getCurrentEventloop();
        eventloop.startExternalTask();
        SettableStage stage = SettableStage.create();
        completionStage.whenCompleteAsync((result, throwable) -> {
            stage.set(result, (Throwable)throwable);
            eventloop.completeExternalTask();
        }, eventloop);
        return stage;
    }

    public static <T> Stage<T> ofFuture(Executor executor, Future<? extends T> future) {
        Eventloop eventloop = Eventloop.getCurrentEventloop();
        eventloop.startExternalTask();
        SettableStage stage = SettableStage.create();
        try {
            executor.execute(() -> {
                try {
                    Object value = future.get();
                    eventloop.execute(() -> stage.set(value));
                }
                catch (ExecutionException e) {
                    eventloop.execute(() -> stage.setException(e.getCause()));
                }
                catch (InterruptedException e) {
                    eventloop.execute(() -> stage.setException(e));
                }
                catch (Throwable e) {
                    eventloop.execute(() -> eventloop.recordFatalError(e, future));
                }
                finally {
                    eventloop.completeExternalTask();
                }
            });
        }
        catch (RejectedExecutionException e) {
            eventloop.completeExternalTask();
            stage.setException(e);
        }
        return stage;
    }

    public static <T> Stage<T> ofCallable(Executor executor, Callable<? extends T> callable) {
        Eventloop eventloop = Eventloop.getCurrentEventloop();
        eventloop.startExternalTask();
        SettableStage stage = SettableStage.create();
        try {
            executor.execute(() -> {
                try {
                    Object result = callable.call();
                    eventloop.execute(() -> stage.set(result));
                }
                catch (CompletionException e) {
                    eventloop.execute(() -> stage.setException(e));
                }
                catch (RuntimeException e) {
                    eventloop.execute(() -> eventloop.recordFatalError(e, callable));
                }
                catch (Exception e) {
                    eventloop.execute(() -> stage.setException(e));
                }
                catch (Throwable e) {
                    eventloop.execute(() -> eventloop.recordFatalError(e, callable));
                }
                finally {
                    eventloop.completeExternalTask();
                }
            });
        }
        catch (RejectedExecutionException e) {
            eventloop.completeExternalTask();
            stage.setException(e);
        }
        return stage;
    }

    public static Stage<Void> ofRunnable(Executor executor, Runnable runnable) {
        Eventloop eventloop = Eventloop.getCurrentEventloop();
        eventloop.startExternalTask();
        SettableStage<Void> stage = SettableStage.create();
        try {
            executor.execute(() -> {
                try {
                    runnable.run();
                    eventloop.execute(() -> stage.set(null));
                }
                catch (CompletionException e) {
                    eventloop.execute(() -> stage.setException(e));
                }
                catch (RuntimeException e) {
                    eventloop.execute(() -> eventloop.recordFatalError(e, runnable));
                }
                catch (Exception e) {
                    eventloop.execute(() -> stage.setException(e));
                }
                catch (Throwable e) {
                    eventloop.execute(() -> eventloop.recordFatalError(e, runnable));
                }
                finally {
                    eventloop.completeExternalTask();
                }
            });
        }
        catch (RejectedExecutionException e) {
            eventloop.completeExternalTask();
            stage.setException(e);
        }
        return stage;
    }

    public <U, S extends StageConsumer<? super T> & Stage<U>> Stage<U> then(S var1);

    public <U> Stage<U> thenApply(Function<? super T, ? extends U> var1);

    public <U> Stage<U> thenApplyEx(BiFunction<? super T, Throwable, ? extends U> var1);

    public Stage<T> thenRun(Runnable var1);

    public Stage<T> thenRunEx(Runnable var1);

    public <U> Stage<U> thenCompose(Function<? super T, ? extends Stage<U>> var1);

    public <U> Stage<U> thenComposeEx(BiFunction<? super T, Throwable, ? extends Stage<U>> var1);

    public Stage<T> whenComplete(StageConsumer<? super T> var1);

    public Stage<T> whenResult(Consumer<? super T> var1);

    public Stage<T> whenException(Consumer<Throwable> var1);

    public <U, V> Stage<V> combine(Stage<? extends U> var1, BiFunction<? super T, ? super U, ? extends V> var2);

    public Stage<Void> both(Stage<?> var1);

    public Stage<T> either(Stage<? extends T> var1);

    public Stage<Void> toVoid();

    public Stage<T> timeout(Duration var1);

    public Stage<T> post();

    public Stage<Try<T>> toTry();

    public CompletableFuture<T> toCompletableFuture();
}

