/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.async;

import io.datakernel.async.AsyncCallable;
import io.datakernel.async.CollectListener;
import io.datakernel.async.IndexedCollector;
import io.datakernel.async.NextStage;
import io.datakernel.async.SettableStage;
import io.datakernel.async.Stage;
import io.datakernel.async.StageConsumer;
import io.datakernel.eventloop.ScheduledRunnable;
import io.datakernel.util.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Stages {
    private Stages() {
    }

    public static Stage<Void> all(List<? extends Stage<?>> stages) {
        int size = stages.size();
        if (size == 0) {
            return Stage.of(null);
        }
        if (size == 1) {
            return stages.get(0).toVoid();
        }
        if (size == 2) {
            return stages.get(0).both(stages.get(1));
        }
        StageAll resultStage = new StageAll(stages.size());
        stages.get(0).then(resultStage);
        for (int i = 1; i < size; ++i) {
            stages.get(i).whenComplete((result, throwable) -> {
                if (throwable == null) {
                    if (--resultStage.countdown == 0) {
                        resultStage.complete(null);
                    }
                } else {
                    resultStage.tryCompleteExceptionally(throwable);
                }
            });
        }
        return resultStage;
    }

    public static Stage<Void> all(Stream<? extends Stage<Void>> stages) {
        return Stages.all(stages.collect(Collectors.toList()));
    }

    public static Stage<Void> all(Stage<?> ... stages) {
        return Stages.all(Arrays.asList(stages));
    }

    public static Stage<Void> all(Stage<?> stage1, Stage<?> stage2) {
        return stage1.both(stage2);
    }

    public static Stage<Void> all(Stage<?> stage) {
        return stage.toVoid();
    }

    public static <T> Stage<T> any(List<? extends Stage<? extends T>> stages) {
        int size = stages.size();
        Preconditions.checkArgument((size != 0 ? 1 : 0) != 0);
        if (size == 1) {
            return stages.get(0);
        }
        if (size == 2) {
            return stages.get(0).either(stages.get(1));
        }
        StageAny resultStage = new StageAny(size);
        stages.get(0).then(resultStage);
        for (int i = 1; i < size; ++i) {
            stages.get(i).whenComplete((result, throwable) -> {
                if (throwable == null) {
                    resultStage.tryComplete(result);
                } else if (--resultStage.errors == 0) {
                    resultStage.completeExceptionally(throwable);
                }
            });
        }
        return resultStage;
    }

    @SafeVarargs
    public static <T> Stage<T> any(Stage<? extends T> ... stages) {
        return Stages.any(Arrays.asList(stages));
    }

    public static <T> Stage<T> any(Stage<? extends T> stage1, Stage<? extends T> stage2) {
        return stage1.either(stage2);
    }

    public static <T> Stage<T> any(Stage<? extends T> stage) {
        return stage;
    }

    public static <A, T, R> Stage<R> collect(List<? extends Stage<? extends T>> stages, IndexedCollector<T, A, R> collector) {
        int size = stages.size();
        if (size == 0) {
            return Stage.of(collector.resultOf());
        }
        if (size == 1) {
            return stages.get(0).thenApply(collector::resultOf);
        }
        if (size == 2) {
            return stages.get(0).combine(stages.get(1), collector::resultOf);
        }
        A accumulator = collector.accumulator(size);
        StageCollect resultStage = new StageCollect(collector, accumulator, size);
        stages.get(0).then(resultStage);
        for (int i = 1; i < size; ++i) {
            int index = i;
            stages.get(i).whenComplete((result, throwable) -> {
                if (throwable == null) {
                    resultStage.processComplete(result, index);
                } else {
                    resultStage.tryCompleteExceptionally(throwable);
                }
            });
        }
        return resultStage;
    }

    public static <A, T, R> Stage<R> collect(List<? extends Stage<? extends T>> stages, CollectListener<T, A, R> listener, IndexedCollector<T, A, R> collector) {
        int size = stages.size();
        if (size == 0) {
            R finished = collector.resultOf();
            listener.onCollectResult(finished);
            return Stage.of(finished);
        }
        A accumulator = collector.accumulator(size);
        StageReduceEx resultStage = new StageReduceEx(collector, listener, accumulator, size);
        listener.onStart(resultStage, accumulator);
        stages.get(0).then(resultStage);
        for (int i = 1; i < size; ++i) {
            int index = i;
            stages.get(i).whenComplete((result, throwable) -> {
                if (throwable == null) {
                    resultStage.processComplete(result, index);
                } else {
                    resultStage.processException(throwable, index);
                }
            });
        }
        return resultStage;
    }

    public static <T> Stage<List<T>> collectToList(List<? extends Stage<? extends T>> stages) {
        return Stages.collect(stages, IndexedCollector.toList());
    }

    public static <T> Stage<List<T>> collectToList(Stream<? extends Stage<? extends T>> stages) {
        List list = stages.collect(Collectors.toList());
        return Stages.collectToList(list);
    }

    @SafeVarargs
    public static <T> Stage<List<T>> collectToList(Stage<? extends T> ... stages) {
        return Stages.collectToList(Arrays.asList(stages));
    }

    public static <T> Stage<List<T>> collectToList(Stage<? extends T> stage1, Stage<? extends T> stage2) {
        return stage1.combine(stage2, (value1, value2) -> Arrays.asList(value1, value2));
    }

    public static <T> Stage<List<T>> collectToList(Stage<? extends T> stage1) {
        return stage1.thenApply(Collections::singletonList);
    }

    public static <T> Stage<T[]> collectToArray(List<? extends Stage<? extends T>> stages) {
        return Stages.collect(stages, IndexedCollector.toArray());
    }

    public static <T> Stage<T[]> collectToArray(Stream<? extends Stage<? extends T>> stages) {
        List list = stages.collect(Collectors.toList());
        return Stages.collectToArray(list);
    }

    @SafeVarargs
    public static <T> Stage<T[]> collectToArray(Stage<? extends T> ... stages) {
        return Stages.collectToArray(Arrays.asList(stages));
    }

    public static <T> Stage<T[]> collectToArray(Stage<? extends T> stage1, Stage<? extends T> stage2) {
        return stage1.combine(stage2, (value1, value2) -> new Object[]{value1, value2});
    }

    /*
     * Exception decompiling
     */
    public static <T> Stage<T[]> collectToArray(Stage<? extends T> stage1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Stage<Void> runSequence(Iterator<? extends AsyncCallable<?>> stages) {
        SettableStage<Void> result = SettableStage.create();
        Stages.runSequenceImpl(stages, result);
        return result;
    }

    private static void runSequenceImpl(Iterator<? extends AsyncCallable<?>> stages, SettableStage<Void> cb) {
        if (!stages.hasNext()) {
            cb.set(null);
            return;
        }
        stages.next().call().whenComplete((result, throwable) -> {
            if (throwable == null) {
                Stages.runSequenceImpl(stages, cb);
            } else {
                cb.setException(throwable);
            }
        });
    }

    public static Stage<Void> runSequence(Iterable<? extends AsyncCallable<?>> stages) {
        return Stages.runSequence(stages.iterator());
    }

    public static Stage<Void> runSequence(AsyncCallable<?> ... stages) {
        return Stages.runSequence(Arrays.asList(stages));
    }

    public static Stage<Void> runSequence(AsyncCallable<?> stage) {
        return stage.call().toVoid();
    }

    public static Stage<Void> runSequence(AsyncCallable<?> stage1, AsyncCallable<?> stage2) {
        return stage1.call().thenCompose($ -> Stages.runSequence(stage2));
    }

    public static Stage<Void> runSequence(AsyncCallable<?> stage1, AsyncCallable<?> stage2, AsyncCallable<?> stage3) {
        return stage1.call().thenCompose($ -> Stages.runSequence(stage2, stage3));
    }

    private static <T, A, R> Stage<R> collectSequenceImpl(Iterator<? extends AsyncCallable<? extends T>> stages, A accumulator, Collector<T, A, R> collector) {
        SettableStage result = SettableStage.create();
        Stages.collectSequenceImpl(stages, accumulator, collector, result);
        return result;
    }

    private static <T, A, R> void collectSequenceImpl(Iterator<? extends AsyncCallable<? extends T>> stages, A accumulator, Collector<T, A, R> collector, SettableStage<R> cb) {
        if (!stages.hasNext()) {
            cb.set(collector.finisher().apply(accumulator));
            return;
        }
        stages.next().call().whenComplete((result, throwable) -> {
            if (throwable == null) {
                collector.accumulator().accept(accumulator, result);
                Stages.collectSequenceImpl(stages, accumulator, collector, cb);
            } else {
                cb.setException(throwable);
            }
        });
    }

    public static <T, A, R> Stage<R> collectSequence(Iterator<? extends AsyncCallable<? extends T>> stages, Collector<T, A, R> collector) {
        A accumulator = collector.supplier().get();
        return Stages.collectSequenceImpl(stages, accumulator, collector);
    }

    public static <T, A, R> Stage<R> collectSequence(Stream<? extends AsyncCallable<? extends T>> stages, Collector<T, A, R> collector) {
        return Stages.collectSequence(stages.iterator(), collector);
    }

    public static <T, A, R> Stage<R> collectSequence(Iterable<? extends AsyncCallable<? extends T>> stages, Collector<T, A, R> collector) {
        return Stages.collectSequence(stages.iterator(), collector);
    }

    public static <T> Stage<T> first(AsyncCallable<? extends T> ... stages) {
        Preconditions.checkArgument((stages.length != 0 ? 1 : 0) != 0);
        return Stages.first(Arrays.asList(stages));
    }

    public static <T> Stage<T> first(Iterable<? extends AsyncCallable<? extends T>> stages) {
        return Stages.first(stages.iterator());
    }

    public static <T> Stage<T> first(Iterator<? extends AsyncCallable<? extends T>> stages) {
        return Stages.first(stages, (? super T t, ? super Throwable throwable) -> throwable == null);
    }

    public static <T> Stage<T> first(Iterable<? extends AsyncCallable<? extends T>> stages, BiPredicate<? super T, ? super Throwable> predicate) {
        return Stages.first(stages.iterator(), predicate);
    }

    public static <T> Stage<T> first(Iterator<? extends AsyncCallable<? extends T>> stages, BiPredicate<? super T, ? super Throwable> predicate) {
        SettableStage cb = SettableStage.create();
        Stages.firstImpl(stages, predicate, cb);
        return cb;
    }

    private static <T> void firstImpl(Iterator<? extends AsyncCallable<? extends T>> stages, BiPredicate<? super T, ? super Throwable> predicate, SettableStage<T> cb) {
        if (!stages.hasNext()) {
            cb.setException(new NoSuchElementException());
            return;
        }
        AsyncCallable<T> callable = stages.next();
        callable.call().whenComplete((result, throwable) -> {
            if (predicate.test(result, throwable)) {
                cb.set(result, throwable);
                return;
            }
            Stages.firstImpl(stages, predicate, cb);
        });
    }

    public static <T> Iterator<Stage<T>> iterator(final Iterator<AsyncCallable<T>> callables) {
        return new Iterator<Stage<T>>(){

            @Override
            public boolean hasNext() {
                return callables.hasNext();
            }

            @Override
            public Stage<T> next() {
                return ((AsyncCallable)callables.next()).call();
            }
        };
    }

    public static <T> Iterable<Stage<T>> iterable(Iterable<AsyncCallable<T>> callables) {
        return () -> Stages.iterator(callables.iterator());
    }

    public static <T> StageConsumer<T> assertComplete(Consumer<T> consumer) {
        return (t, error) -> {
            if (error != null) {
                throw new AssertionError((Object)error);
            }
            consumer.accept(t);
        };
    }

    public static <T> StageConsumer<T> assertComplete() {
        return Stages.assertComplete($ -> {});
    }

    private static final class StageReduceEx<T, A, R>
    extends NextStage<T, R>
    implements CollectListener.CollectCanceller {
        final IndexedCollector<T, A, R> reducer;
        final CollectListener<T, A, R> listener;
        A accumulator;
        int stages;

        private StageReduceEx(IndexedCollector<T, A, R> reducer, CollectListener<T, A, R> listener, A accumulator, int stages) {
            this.reducer = reducer;
            this.listener = listener;
            this.accumulator = accumulator;
            this.stages = stages;
        }

        @Override
        protected void onComplete(T result) {
            this.processComplete(result, 0);
        }

        void processComplete(T stageResult, int index) {
            if (this.isComplete()) {
                return;
            }
            this.reducer.accumulate(this.accumulator, index, stageResult);
            this.listener.onResult(stageResult, index);
            if (--this.stages == 0) {
                this.finish();
            }
        }

        @Override
        public void finish() {
            if (this.isComplete()) {
                return;
            }
            R finished = this.reducer.finish(this.accumulator);
            this.accumulator = null;
            this.listener.onCollectResult(finished);
            if (this.isComplete()) {
                return;
            }
            this.complete(finished);
        }

        @Override
        protected void onCompleteExceptionally(Throwable throwable) {
            this.processException(throwable, 0);
        }

        void processException(Throwable throwable, int index) {
            if (this.isComplete()) {
                return;
            }
            this.listener.onException(throwable, index);
            this.finishExceptionally(throwable);
        }

        @Override
        public void finishExceptionally(Throwable throwable) {
            if (this.isComplete()) {
                return;
            }
            this.listener.onCollectException(throwable);
            if (this.isComplete()) {
                return;
            }
            this.completeExceptionally(throwable);
        }
    }

    static final class ReduceTimeouter<T, A, R>
    implements Runnable,
    CollectListener<T, A, R> {
        CollectListener.CollectCanceller canceller;
        ScheduledRunnable scheduledRunnable;

        ReduceTimeouter() {
        }

        @Override
        public void onStart(CollectListener.CollectCanceller canceller, A accumulator) {
            this.canceller = canceller;
        }

        @Override
        public void onCollectResult(R result) {
            if (this.scheduledRunnable != null) {
                this.scheduledRunnable.cancel();
            }
        }

        @Override
        public void onCollectException(Throwable throwable) {
            if (this.scheduledRunnable != null) {
                this.scheduledRunnable.cancel();
            }
        }

        @Override
        public void run() {
            this.canceller.finish();
        }
    }

    private static final class StageCollect<T, A, R>
    extends NextStage<T, R> {
        final IndexedCollector<T, A, R> reducer;
        A accumulator;
        int stages;

        private StageCollect(IndexedCollector<T, A, R> reducer, A accumulator, int stages) {
            this.reducer = reducer;
            this.accumulator = accumulator;
            this.stages = stages;
        }

        void processComplete(T result, int i) {
            if (this.isComplete()) {
                return;
            }
            this.reducer.accumulate(this.accumulator, i, result);
            if (--this.stages == 0) {
                R reducerResult = this.reducer.finish(this.accumulator);
                this.accumulator = null;
                this.complete(reducerResult);
            }
        }

        @Override
        protected void onComplete(T result) {
            this.processComplete(result, 0);
        }

        @Override
        protected void onCompleteExceptionally(Throwable throwable) {
            this.tryCompleteExceptionally(throwable);
        }
    }

    private static final class StageAny<T>
    extends NextStage<T, T> {
        int errors;

        StageAny(int errors) {
            this.errors = errors;
        }

        @Override
        protected void onComplete(T result) {
            this.tryComplete(result);
        }

        @Override
        protected void onCompleteExceptionally(Throwable throwable) {
            if (--this.errors == 0) {
                this.completeExceptionally(throwable);
            }
        }
    }

    private static final class StageAll<T>
    extends NextStage<T, Void> {
        int countdown;

        public StageAll(int countdown) {
            this.countdown = countdown;
        }

        @Override
        protected void onComplete(T result) {
            if (--this.countdown == 0) {
                this.complete(null);
            }
        }

        @Override
        protected void onCompleteExceptionally(Throwable throwable) {
            this.tryCompleteExceptionally(throwable);
        }
    }
}

