/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.async;

import io.datakernel.async.Reducer;
import io.datakernel.async.SettableStage;
import io.datakernel.async.Stage;

public final class StagesAccumulator<A> {
    private SettableStage<A> resultStage;
    private A accumulator;
    private Throwable exception;
    private int activeStages;

    private StagesAccumulator(A initialAccumulator) {
        this.accumulator = initialAccumulator;
    }

    public static <A> StagesAccumulator<A> create(A initialAccumulator) {
        return new StagesAccumulator<A>(initialAccumulator);
    }

    public <V> StagesAccumulator<A> withStage(Stage<V> stage, Reducer<A, V> reducer) {
        this.addStage(stage, reducer);
        return this;
    }

    public <V> Stage<V> addStage(Stage<V> stage, Reducer<A, V> reducer) {
        ++this.activeStages;
        return stage.whenComplete((result, throwable) -> {
            if (throwable == null) {
                if (this.accumulator != null) {
                    reducer.accumulate(this.accumulator, result);
                    assert (this.accumulator != null);
                }
                --this.activeStages;
                if (this.activeStages == 0 && this.resultStage != null && this.exception == null) {
                    this.resultStage.set(this.accumulator);
                    this.resultStage = null;
                }
            } else {
                --this.activeStages;
                if (this.exception == null) {
                    this.exception = throwable;
                    this.accumulator = null;
                    if (this.resultStage != null) {
                        this.resultStage.setException(throwable);
                        this.resultStage = null;
                    }
                }
            }
        });
    }

    public <V> SettableStage<V> newStage(Reducer<A, V> reducer) {
        SettableStage resultStage = SettableStage.create();
        this.addStage(resultStage, reducer);
        return resultStage;
    }

    public Stage<A> get() {
        if (this.resultStage != null) {
            return this.resultStage;
        }
        this.resultStage = SettableStage.create();
        if (this.exception != null) {
            this.resultStage.setException(this.exception);
            return this.resultStage;
        }
        if (this.activeStages == 0) {
            this.resultStage.set(this.accumulator);
            return this.resultStage;
        }
        return this.resultStage;
    }

    public A getAccumulator() {
        return this.accumulator;
    }

    public Throwable getException() {
        return this.exception;
    }

    public int getActiveStages() {
        return this.activeStages;
    }
}

