/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.eventloop;

import io.datakernel.async.SettableStage;
import io.datakernel.async.Stage;
import io.datakernel.eventloop.AsyncSslSocket;
import io.datakernel.eventloop.AsyncTcpSocket;
import io.datakernel.eventloop.AsyncTcpSocketImpl;
import io.datakernel.eventloop.Eventloop;
import io.datakernel.eventloop.EventloopServer;
import io.datakernel.eventloop.PrimaryServer;
import io.datakernel.eventloop.WorkerServer;
import io.datakernel.jmx.EventStats;
import io.datakernel.jmx.EventloopJmxMBeanEx;
import io.datakernel.jmx.JmxAttribute;
import io.datakernel.net.ServerSocketSettings;
import io.datakernel.net.SocketSettings;
import io.datakernel.util.Initializable;
import io.datakernel.util.Preconditions;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServer<S extends AbstractServer<S>>
implements EventloopServer,
WorkerServer,
Initializable<S>,
EventloopJmxMBeanEx {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final Eventloop eventloop;
    public static final ServerSocketSettings DEFAULT_SERVER_SOCKET_SETTINGS = ServerSocketSettings.create(16384);
    public static final SocketSettings DEFAULT_SOCKET_SETTINGS = SocketSettings.create();
    protected ServerSocketSettings serverSocketSettings = DEFAULT_SERVER_SOCKET_SETTINGS;
    protected SocketSettings socketSettings = DEFAULT_SOCKET_SETTINGS;
    private boolean acceptOnce;
    private AcceptFilter acceptFilter;
    private List<InetSocketAddress> listenAddresses = new ArrayList<InetSocketAddress>();
    private SSLContext sslContext;
    private ExecutorService sslExecutor;
    private List<InetSocketAddress> sslListenAddresses = new ArrayList<InetSocketAddress>();
    private boolean running = false;
    private List<ServerSocketChannel> serverSocketChannels;
    private static final Duration SMOOTHING_WINDOW = Duration.ofMinutes(1L);
    AbstractServer acceptServer = this;
    private final AsyncTcpSocketImpl.JmxInspector socketStats = new AsyncTcpSocketImpl.JmxInspector();
    private final AsyncTcpSocketImpl.JmxInspector socketStatsSsl = new AsyncTcpSocketImpl.JmxInspector();
    private final EventStats accepts = EventStats.create(SMOOTHING_WINDOW);
    private final EventStats acceptsSsl = EventStats.create(SMOOTHING_WINDOW);
    private final EventStats filteredAccepts = EventStats.create(SMOOTHING_WINDOW);

    protected AbstractServer(Eventloop eventloop) {
        this.eventloop = eventloop;
    }

    public final S withAcceptFilter(AcceptFilter acceptFilter) {
        this.acceptFilter = acceptFilter;
        return (S)this;
    }

    public final S withServerSocketSettings(ServerSocketSettings serverSocketSettings) {
        this.serverSocketSettings = serverSocketSettings;
        return (S)this;
    }

    public final S withSocketSettings(SocketSettings socketSettings) {
        this.socketSettings = socketSettings;
        return (S)this;
    }

    public final S withListenAddresses(List<InetSocketAddress> addresses) {
        this.listenAddresses = addresses;
        return (S)this;
    }

    public final S withListenAddresses(InetSocketAddress ... addresses) {
        return this.withListenAddresses(Arrays.asList(addresses));
    }

    public final S withListenAddress(InetSocketAddress address) {
        return this.withListenAddresses(Collections.singletonList(address));
    }

    public final S withListenPort(int port) {
        return this.withListenAddress(new InetSocketAddress(port));
    }

    public final S withSslListenAddresses(SSLContext sslContext, ExecutorService sslExecutor, List<InetSocketAddress> addresses) {
        this.sslContext = sslContext;
        this.sslExecutor = sslExecutor;
        this.sslListenAddresses = addresses;
        return (S)this;
    }

    public final S withSslListenAddresses(SSLContext sslContext, ExecutorService sslExecutor, InetSocketAddress ... addresses) {
        return this.withSslListenAddresses(sslContext, sslExecutor, Arrays.asList(addresses));
    }

    public final S withSslListenAddress(SSLContext sslContext, ExecutorService sslExecutor, InetSocketAddress address) {
        return this.withSslListenAddresses(sslContext, sslExecutor, Collections.singletonList(address));
    }

    public final S withSslListenPort(SSLContext sslContext, ExecutorService sslExecutor, int port) {
        return this.withSslListenAddress(sslContext, sslExecutor, new InetSocketAddress(port));
    }

    public final S withAcceptOnce() {
        return this.withAcceptOnce(true);
    }

    public final S withAcceptOnce(boolean acceptOnce) {
        this.acceptOnce = acceptOnce;
        return (S)this;
    }

    public final S withLogger(Logger logger) {
        this.logger = logger;
        return (S)this;
    }

    public ServerSocketSettings getServerSocketSettings() {
        return this.serverSocketSettings;
    }

    public SocketSettings getSocketSettings() {
        return this.socketSettings;
    }

    @Override
    public final Eventloop getEventloop() {
        return this.eventloop;
    }

    @Override
    public final void listen() throws IOException {
        Preconditions.check((boolean)this.eventloop.inEventloopThread());
        if (this.running) {
            return;
        }
        this.running = true;
        this.onListen();
        this.serverSocketChannels = new ArrayList<ServerSocketChannel>();
        if (this.listenAddresses != null && !this.listenAddresses.isEmpty()) {
            this.listenAddresses(this.listenAddresses, false);
            this.logger.info("Listening on {}", this.listenAddresses);
        }
        if (this.sslListenAddresses != null && !this.sslListenAddresses.isEmpty()) {
            this.listenAddresses(this.sslListenAddresses, true);
            this.logger.info("Listening SSL on {}", this.sslListenAddresses);
        }
    }

    private void listenAddresses(List<InetSocketAddress> addresses, boolean ssl) throws IOException {
        for (InetSocketAddress address : addresses) {
            try {
                ServerSocketChannel serverSocketChannel = this.eventloop.listen(address, this.serverSocketSettings, chan -> this.doAccept(chan, address, ssl));
                this.serverSocketChannels.add(serverSocketChannel);
            }
            catch (IOException e) {
                this.logger.error("Can't listen on {}", (Object)this, (Object)address);
                this.close();
                throw e;
            }
        }
    }

    protected void onListen() {
    }

    @Override
    public final Stage<Void> close() {
        Preconditions.check((boolean)this.eventloop.inEventloopThread());
        if (!this.running) {
            return Stage.of(null);
        }
        this.running = false;
        this.closeServerSocketChannels();
        SettableStage<Void> stage = SettableStage.create();
        this.onClose(stage);
        return stage;
    }

    public final Future<?> closeFuture() {
        return this.eventloop.submit(this::close);
    }

    protected void onClose(SettableStage<Void> stage) {
        stage.set(null);
    }

    public boolean isRunning() {
        return this.running;
    }

    private void closeServerSocketChannels() {
        if (this.serverSocketChannels == null || this.serverSocketChannels.isEmpty()) {
            return;
        }
        Iterator<ServerSocketChannel> it = this.serverSocketChannels.iterator();
        while (it.hasNext()) {
            ServerSocketChannel serverSocketChannel = it.next();
            if (serverSocketChannel == null) continue;
            this.eventloop.closeChannel(serverSocketChannel);
            it.remove();
        }
    }

    protected WorkerServer getWorkerServer() {
        return this;
    }

    protected AsyncTcpSocketImpl.Inspector getSocketInspector(InetAddress remoteAddress, InetSocketAddress localAddress, boolean ssl) {
        return ssl ? this.socketStatsSsl : this.socketStats;
    }

    protected void onAccept(SocketChannel socketChannel, InetSocketAddress localAddress, InetAddress remoteAddress, boolean ssl) {
        this.accepts.recordEvent();
        if (ssl) {
            this.acceptsSsl.recordEvent();
        }
    }

    protected void onFilteredAccept(SocketChannel socketChannel, InetSocketAddress localAddress, InetAddress remoteAddress, boolean ssl) {
        this.filteredAccepts.recordEvent();
    }

    private void doAccept(SocketChannel socketChannel, InetSocketAddress localAddress, boolean ssl) {
        InetAddress remoteAddress;
        assert (this.eventloop.inEventloopThread());
        try {
            remoteAddress = ((InetSocketAddress)socketChannel.getRemoteAddress()).getAddress();
        }
        catch (IOException e) {
            this.eventloop.closeChannel(socketChannel);
            return;
        }
        if (this.acceptFilter != null && this.acceptFilter.filterAccept(socketChannel, localAddress, remoteAddress, ssl)) {
            this.onFilteredAccept(socketChannel, localAddress, remoteAddress, ssl);
            return;
        }
        WorkerServer workerServer = this.getWorkerServer();
        Eventloop workerServerEventloop = workerServer.getEventloop();
        if (workerServerEventloop == this.eventloop) {
            workerServer.doAccept(socketChannel, localAddress, remoteAddress, ssl, this.socketSettings);
        } else {
            this.onAccept(socketChannel, localAddress, remoteAddress, ssl);
            workerServerEventloop.execute(() -> workerServer.doAccept(socketChannel, localAddress, remoteAddress, ssl, this.socketSettings));
        }
        if (this.acceptOnce) {
            this.close();
        }
    }

    @Override
    public void doAccept(SocketChannel socketChannel, InetSocketAddress localAddress, InetAddress remoteAddress, boolean ssl, SocketSettings socketSettings) {
        assert (this.eventloop.inEventloopThread());
        this.onAccept(socketChannel, localAddress, remoteAddress, ssl);
        AsyncTcpSocketImpl asyncTcpSocketImpl = AsyncTcpSocketImpl.wrapChannel(this.eventloop, socketChannel, socketSettings).withInspector(this.getSocketInspector(remoteAddress, localAddress, ssl));
        AsyncTcpSocketImpl asyncTcpSocket = ssl ? AsyncSslSocket.wrapServerSocket(this.eventloop, asyncTcpSocketImpl, this.sslContext, this.sslExecutor) : asyncTcpSocketImpl;
        asyncTcpSocket.setEventHandler(this.createSocketHandler(asyncTcpSocket));
        asyncTcpSocketImpl.register();
    }

    protected abstract AsyncTcpSocket.EventHandler createSocketHandler(AsyncTcpSocket var1);

    private boolean isInetAddressAny(InetSocketAddress listenAddress) {
        return listenAddress.getAddress().isAnyLocalAddress();
    }

    @JmxAttribute(extraSubAttributes={"totalCount"})
    public final EventStats getAccepts() {
        return this.acceptServer.listenAddresses.isEmpty() ? null : this.accepts;
    }

    @JmxAttribute
    public EventStats getAcceptsSsl() {
        return this.acceptServer.sslListenAddresses.isEmpty() ? null : this.acceptsSsl;
    }

    @JmxAttribute
    public EventStats getFilteredAccepts() {
        return this.acceptFilter == null ? null : this.filteredAccepts;
    }

    @JmxAttribute
    public AsyncTcpSocketImpl.JmxInspector getSocketStats() {
        return this instanceof PrimaryServer || this.acceptServer.listenAddresses.isEmpty() ? null : this.socketStats;
    }

    @JmxAttribute
    public AsyncTcpSocketImpl.JmxInspector getSocketStatsSsl() {
        return this instanceof PrimaryServer || this.acceptServer.sslListenAddresses.isEmpty() ? null : this.socketStatsSsl;
    }

    public static interface AcceptFilter {
        public boolean filterAccept(SocketChannel var1, InetSocketAddress var2, InetAddress var3, boolean var4);
    }
}

