/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.eventloop;

import io.datakernel.bytebuf.ByteBuf;
import io.datakernel.bytebuf.ByteBufPool;
import io.datakernel.eventloop.AsyncTcpSocket;
import io.datakernel.eventloop.Eventloop;
import io.datakernel.net.CloseWithoutNotifyException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;

public final class AsyncSslSocket
implements AsyncTcpSocket,
AsyncTcpSocket.EventHandler {
    private final Eventloop eventloop;
    private final SSLEngine engine;
    private final Executor executor;
    private final AsyncTcpSocket upstream;
    private AsyncTcpSocket.EventHandler downstreamEventHandler;
    private ByteBuf net2engine = ByteBuf.empty();
    private ByteBuf engine2app = ByteBuf.empty();
    private ByteBuf app2engine = ByteBuf.empty();
    private boolean syncPosted = false;
    private boolean read = false;
    private boolean write = false;

    public static AsyncSslSocket wrapClientSocket(Eventloop eventloop, AsyncTcpSocket asyncTcpSocket, String host, int port, SSLContext sslContext, Executor executor) {
        SSLEngine sslEngine = sslContext.createSSLEngine(host, port);
        sslEngine.setUseClientMode(true);
        return AsyncSslSocket.wrapSocket(eventloop, asyncTcpSocket, sslEngine, executor);
    }

    public static AsyncSslSocket wrapClientSocket(Eventloop eventloop, AsyncTcpSocket asyncTcpSocket, SSLContext sslContext, Executor executor) {
        SSLEngine sslEngine = sslContext.createSSLEngine();
        sslEngine.setUseClientMode(true);
        return AsyncSslSocket.wrapSocket(eventloop, asyncTcpSocket, sslEngine, executor);
    }

    public static AsyncSslSocket wrapServerSocket(Eventloop eventloop, AsyncTcpSocket asyncTcpSocket, SSLContext sslContext, Executor executor) {
        SSLEngine sslEngine = sslContext.createSSLEngine();
        sslEngine.setUseClientMode(false);
        return AsyncSslSocket.wrapSocket(eventloop, asyncTcpSocket, sslEngine, executor);
    }

    public static AsyncSslSocket wrapSocket(Eventloop eventloop, AsyncTcpSocket asyncTcpSocket, SSLEngine engine, Executor executor) {
        AsyncSslSocket asyncSslSocket = AsyncSslSocket.create(eventloop, asyncTcpSocket, engine, executor);
        asyncTcpSocket.setEventHandler(asyncSslSocket);
        return asyncSslSocket;
    }

    private AsyncSslSocket(Eventloop eventloop, AsyncTcpSocket asyncTcpSocket, SSLEngine engine, Executor executor) {
        this.eventloop = eventloop;
        this.engine = engine;
        this.executor = executor;
        this.upstream = asyncTcpSocket;
    }

    public static AsyncSslSocket create(Eventloop eventloop, AsyncTcpSocket asyncTcpSocket, SSLEngine engine, Executor executor) {
        return new AsyncSslSocket(eventloop, asyncTcpSocket, engine, executor);
    }

    @Override
    public void onRegistered() {
        this.downstreamEventHandler.onRegistered();
        try {
            this.engine.beginHandshake();
            this.doSync();
        }
        catch (SSLException e) {
            this.upstream.close();
            this.eventloop.post(() -> {
                if (this.engine2app != null) {
                    this.downstreamEventHandler.onClosedWithError(e);
                }
                this.recycleByteBufs();
            });
        }
    }

    @Override
    public void onRead(ByteBuf buf) {
        this.net2engine = ByteBufPool.append((ByteBuf)this.net2engine, (ByteBuf)buf);
        this.sync();
    }

    @Override
    public void onReadEndOfStream() {
        if (this.engine.isInboundDone()) {
            return;
        }
        try {
            this.engine.closeInbound();
        }
        catch (SSLException e) {
            if (this.app2engine != null) {
                this.downstreamEventHandler.onClosedWithError((Exception)((Object)new CloseWithoutNotifyException(e)));
            }
            this.upstream.close();
            this.recycleByteBufs();
        }
    }

    @Override
    public void onWrite() {
        if (this.engine.isOutboundDone()) {
            this.upstream.close();
            this.recycleByteBufs();
            return;
        }
        if (this.engine2app != null && !this.app2engine.canRead() && this.engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING && this.write) {
            this.write = false;
            this.downstreamEventHandler.onWrite();
        }
    }

    @Override
    public void onClosedWithError(Exception e) {
        if (this.engine2app != null) {
            this.downstreamEventHandler.onClosedWithError(e);
        }
        this.recycleByteBufs();
    }

    @Override
    public void setEventHandler(AsyncTcpSocket.EventHandler eventHandler) {
        this.downstreamEventHandler = eventHandler;
    }

    @Override
    public void read() {
        this.read = true;
        if (!this.net2engine.canRead() && !this.engine2app.canRead()) {
            this.upstream.read();
        }
        this.postSync();
    }

    @Override
    public void write(ByteBuf buf) {
        this.write = true;
        this.app2engine = ByteBufPool.append((ByteBuf)this.app2engine, (ByteBuf)buf);
        this.postSync();
    }

    @Override
    public void writeEndOfStream() {
        throw new UnsupportedOperationException("SSL cannot work in half-duplex mode");
    }

    @Override
    public void close() {
        if (this.engine2app == null) {
            return;
        }
        this.engine2app.recycle();
        this.engine2app = null;
        this.app2engine.recycle();
        this.app2engine = ByteBuf.empty();
        this.engine.closeOutbound();
        this.postSync();
    }

    private void recycleByteBufs() {
        if (this.net2engine != null) {
            this.net2engine.recycle();
        }
        if (this.engine2app != null) {
            this.engine2app.recycle();
        }
        if (this.app2engine != null) {
            this.app2engine.recycle();
        }
        this.app2engine = null;
        this.engine2app = null;
        this.net2engine = null;
    }

    @Override
    public InetSocketAddress getRemoteSocketAddress() {
        return this.upstream.getRemoteSocketAddress();
    }

    private SSLEngineResult tryToUnwrap() throws SSLException {
        SSLEngineResult result;
        ByteBuf dstBuf = ByteBufPool.allocate((int)this.engine.getSession().getPacketBufferSize());
        ByteBuffer srcBuffer = this.net2engine.toReadByteBuffer();
        ByteBuffer dstBuffer = dstBuf.toWriteByteBuffer();
        try {
            result = this.engine.unwrap(srcBuffer, dstBuffer);
        }
        catch (SSLException e) {
            dstBuf.recycle();
            throw e;
        }
        catch (RuntimeException e) {
            dstBuf.recycle();
            throw new SSLException(e);
        }
        this.net2engine.ofReadByteBuffer(srcBuffer);
        this.net2engine = ByteBufPool.recycleIfEmpty((ByteBuf)this.net2engine);
        dstBuf.ofWriteByteBuffer(dstBuffer);
        if (this.engine2app != null && dstBuf.canRead()) {
            this.engine2app = ByteBufPool.append((ByteBuf)this.engine2app, (ByteBuf)dstBuf);
        } else {
            dstBuf.recycle();
        }
        return result;
    }

    private SSLEngineResult tryToWrap() throws SSLException {
        SSLEngineResult result;
        ByteBuf dstBuf = ByteBufPool.allocate((int)this.engine.getSession().getPacketBufferSize());
        ByteBuffer srcBuffer = this.app2engine.toReadByteBuffer();
        ByteBuffer dstBuffer = dstBuf.toWriteByteBuffer();
        try {
            result = this.engine.wrap(srcBuffer, dstBuffer);
        }
        catch (SSLException e) {
            dstBuf.recycle();
            throw e;
        }
        catch (RuntimeException e) {
            dstBuf.recycle();
            throw new SSLException(e);
        }
        this.app2engine.ofReadByteBuffer(srcBuffer);
        this.app2engine = ByteBufPool.recycleIfEmpty((ByteBuf)this.app2engine);
        dstBuf.ofWriteByteBuffer(dstBuffer);
        if (dstBuf.canRead()) {
            this.upstream.write(dstBuf);
        } else {
            dstBuf.recycle();
        }
        return result;
    }

    private void executeTasks() {
        Runnable task;
        while ((task = this.engine.getDelegatedTask()) != null) {
            this.executor.execute(() -> {
                task.run();
                this.eventloop.execute(() -> {
                    if (this.net2engine == null) {
                        return;
                    }
                    this.sync();
                });
            });
        }
    }

    private void postSync() {
        if (!this.syncPosted) {
            this.syncPosted = true;
            this.eventloop.post(this::sync);
        }
    }

    private void sync() {
        this.syncPosted = false;
        try {
            this.doSync();
        }
        catch (SSLException e) {
            this.upstream.close();
            if (this.engine2app != null) {
                this.downstreamEventHandler.onClosedWithError(e);
            }
            this.recycleByteBufs();
        }
    }

    private void doSync() throws SSLException {
        SSLEngineResult result;
        block13: {
            SSLEngineResult.HandshakeStatus handshakeStatus;
            block14: {
                result = null;
                while (true) {
                    if (result != null && result.getStatus() == SSLEngineResult.Status.CLOSED) {
                        this.upstream.close();
                        this.net2engine.recycle();
                        this.app2engine.recycle();
                        this.app2engine = null;
                        this.net2engine = null;
                        break block13;
                    }
                    handshakeStatus = this.engine.getHandshakeStatus();
                    if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                        result = this.tryToWrap();
                        continue;
                    }
                    if (handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_UNWRAP) break block14;
                    result = this.tryToUnwrap();
                    if (result.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) break;
                }
                this.upstream.read();
                break block13;
            }
            if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                this.executeTasks();
                return;
            }
            if (handshakeStatus == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                if (result != null && result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
                    this.upstream.read();
                }
                if (this.net2engine.canRead()) {
                    do {
                        result = this.tryToUnwrap();
                    } while (this.net2engine.canRead() && (result.bytesConsumed() != 0 || result.bytesProduced() != 0));
                    if (result.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                        this.upstream.read();
                    }
                }
                if (this.app2engine.canRead()) {
                    do {
                        result = this.tryToWrap();
                    } while (this.app2engine.canRead() && (result.bytesConsumed() != 0 || result.bytesProduced() != 0));
                }
            }
        }
        if (this.engine2app != null && this.read && this.engine2app.canRead()) {
            this.read = false;
            ByteBuf readBuf = this.engine2app;
            this.engine2app = ByteBuf.empty();
            this.downstreamEventHandler.onRead(readBuf);
        }
        if (this.engine2app != null && result != null && result.getStatus() == SSLEngineResult.Status.CLOSED) {
            this.downstreamEventHandler.onReadEndOfStream();
        }
    }
}

